/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.sleuth.zipkin2.DefaultEndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;

public abstract class DefaultEndpointLocatorConfigurationTest {
    protected static final byte[] ADDRESS1234 = new byte[]{1, 2, 3, 4};
    Environment environment = new MockEnvironment();

    @Test
    public void endpointLocatorShouldDefaultToServerPropertiesEndpointLocator() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{EmptyConfiguration.class})).withPropertyValues(new String[]{"spring.jmx.enabled=false"})).run(ctxt -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).hasSingleBean(DefaultEndpointLocator.class));
    }

    @Test
    public void endpointLocatorShouldDefaultToServerPropertiesEndpointLocatorEvenWhenDiscoveryClientPresent() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{ConfigurationWithRegistration.class})).withPropertyValues(new String[]{"spring.jmx.enabled=false"})).run(ctxt -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).hasSingleBean(DefaultEndpointLocator.class));
    }

    @Test
    public void endpointLocatorShouldRespectExistingEndpointLocator() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{ConfigurationWithCustomLocator.class})).withPropertyValues(new String[]{"spring.jmx.enabled=false"})).run(ctxt -> Assertions.assertThat((Object)((EndpointLocator)ctxt.getBean(EndpointLocator.class))).isSameAs((Object)ConfigurationWithCustomLocator.locator));
    }

    @Test
    public void endpointLocatorShouldSetServiceNameToServiceId() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{ConfigurationWithRegistration.class})).withPropertyValues(new String[]{"spring.jmx.enabled=false", "spring.zipkin.locator.discovery.enabled=true"})).run(ctxt -> Assertions.assertThat((String)((EndpointLocator)ctxt.getBean(EndpointLocator.class)).local().serviceName()).isEqualTo("from-registration"));
    }

    @Test
    public void endpointLocatorShouldAcceptServiceNameOverride() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{ConfigurationWithRegistration.class})).withPropertyValues(new String[]{"spring.jmx.enabled=false", "spring.zipkin.locator.discovery.enabled=true", "spring.zipkin.service.name=foo"})).run(ctxt -> Assertions.assertThat((String)((EndpointLocator)ctxt.getBean(EndpointLocator.class)).local().serviceName()).isEqualTo("foo"));
    }

    @Test
    public void endpointLocatorShouldRespectExistingEndpointLocatorEvenWhenAskedToBeDiscovery() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{ConfigurationWithRegistration.class, ConfigurationWithCustomLocator.class})).withPropertyValues(new String[]{"spring.jmx.enabled=false", "spring.zipkin.locator.discovery.enabled=true"})).run(ctxt -> Assertions.assertThat((Object)((EndpointLocator)ctxt.getBean(EndpointLocator.class))).isSameAs((Object)ConfigurationWithCustomLocator.locator));
    }

    @Test
    public void portDefaultsTo8080() throws UnknownHostException {
        DefaultEndpointLocator locator = new DefaultEndpointLocator(null, new ServerProperties(), this.environment, new ZipkinProperties(), this.localAddress(ADDRESS1234));
        Assertions.assertThat((Integer)locator.local().port()).isEqualTo(8080);
    }

    @Test
    public void portFromServerProperties() throws UnknownHostException {
        ServerProperties properties = new ServerProperties();
        properties.setPort(Integer.valueOf(1234));
        DefaultEndpointLocator locator = new DefaultEndpointLocator(null, properties, this.environment, new ZipkinProperties(), this.localAddress(ADDRESS1234));
        Assertions.assertThat((Integer)locator.local().port()).isEqualTo(1234);
    }

    @Test
    public void portDefaultsToLocalhost() throws UnknownHostException {
        DefaultEndpointLocator locator = new DefaultEndpointLocator(null, new ServerProperties(), this.environment, new ZipkinProperties(), this.localAddress(ADDRESS1234));
        Assertions.assertThat((String)locator.local().ipv4()).isEqualTo("1.2.3.4");
    }

    @Test
    public void hostFromServerPropertiesIp() throws UnknownHostException {
        ServerProperties properties = new ServerProperties();
        properties.setAddress(InetAddress.getByAddress(ADDRESS1234));
        DefaultEndpointLocator locator = new DefaultEndpointLocator(null, properties, this.environment, new ZipkinProperties(), this.localAddress(new byte[]{4, 4, 4, 4}));
        Assertions.assertThat((String)locator.local().ipv4()).isEqualTo("1.2.3.4");
    }

    @Test
    public void appNameFromProperties() throws UnknownHostException {
        ServerProperties properties = new ServerProperties();
        ZipkinProperties zipkinProperties = new ZipkinProperties();
        zipkinProperties.getService().setName("foo");
        DefaultEndpointLocator locator = new DefaultEndpointLocator(null, properties, this.environment, zipkinProperties, this.localAddress(ADDRESS1234));
        Assertions.assertThat((String)locator.local().serviceName()).isEqualTo("foo");
    }

    @Test
    public void negativePortFromServerProperties() throws UnknownHostException {
        ServerProperties properties = new ServerProperties();
        properties.setPort(Integer.valueOf(-1));
        DefaultEndpointLocator locator = new DefaultEndpointLocator(null, properties, this.environment, new ZipkinProperties(), this.localAddress(ADDRESS1234));
        Assertions.assertThat((Integer)locator.local().port()).isEqualTo(8080);
    }

    private InetUtils localAddress(byte[] address) throws UnknownHostException {
        InetUtils mocked = (InetUtils)Mockito.spy((Object)new InetUtils(new InetUtilsProperties()));
        Mockito.when((Object)mocked.findFirstNonLoopbackAddress()).thenReturn((Object)InetAddress.getByAddress(address));
        return mocked;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class EmptyConfiguration {
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class ConfigurationWithRegistration {
        @Bean
        public Registration getRegistration() {
            return new Registration(){

                public String getServiceId() {
                    return "from-registration";
                }

                public String getHost() {
                    return null;
                }

                public int getPort() {
                    return 0;
                }

                public boolean isSecure() {
                    return false;
                }

                public URI getUri() {
                    return null;
                }

                public Map<String, String> getMetadata() {
                    return null;
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class ConfigurationWithCustomLocator {
        static EndpointLocator locator = (EndpointLocator)Mockito.mock(EndpointLocator.class);

        @Bean
        public EndpointLocator getEndpointLocator() {
            return locator;
        }
    }
}

