/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class SleuthSpanCreatorAspectFluxTests {
    @Autowired
    TestBeanInterface testBean;
    @Autowired
    CurrentTraceContext currentTraceContext;
    @Autowired
    Tracer tracer;
    @Autowired
    TestSpanHandler spans;
    TraceContext context = this.traceContext();

    public abstract TraceContext traceContext();

    protected static String id(Tracer tracer) {
        if (tracer.currentSpan() == null) {
            throw new IllegalStateException("Current Span is supposed to have a value!");
        }
        return tracer.currentSpan().context().spanId();
    }

    protected static String id(Context context, Tracer tracer) {
        if (context.hasKey(TraceContext.class)) {
            return ((TraceContext)context.get(TraceContext.class)).spanId();
        }
        return SleuthSpanCreatorAspectFluxTests.id(tracer);
    }

    @BeforeEach
    @AfterEach
    public void setup() {
        this.spans.clear();
        this.testBean.reset();
        this.tracer.withSpan(null);
    }

    @Test
    public void newSpan_shouldContinueExistingTrace() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            Flux<String> flux = this.testBean.testMethod();
            this.verifyNoSpansUntilFluxComplete(flux);
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getTraceId()).isEqualTo(this.context.traceId());
            BDDAssertions.then((String)this.spans.get(0).getParentId()).isEqualTo(this.context.spanId());
        });
    }

    @Test
    public void shouldCreateSpanWhenAnnotationOnInterfaceMethod() {
        Flux<String> flux = this.testBean.testMethod();
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWhenAnnotationOnClassMethod() {
        Flux<String> flux = this.testBean.testMethod2();
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method2");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithCustomNameWhenAnnotationOnClassMethod() {
        Flux<String> flux = this.testBean.testMethod3();
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method3");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithCustomNameWhenAnnotationOnInterfaceMethod() {
        Flux<String> flux = this.testBean.testMethod4();
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method4");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithTagWhenAnnotationOnInterfaceMethod() {
        Flux<String> flux = this.testBean.testMethod5("test");
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method5");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag", (Object)"test");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithTagWhenAnnotationOnClassMethod() {
        Flux<String> flux = this.testBean.testMethod6("test");
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method6");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag6", (Object)"test");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithLogWhenAnnotationOnInterfaceMethod() {
        Flux<String> flux = this.testBean.testMethod8("test");
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method8");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldCreateSpanWithLogWhenAnnotationOnClassMethod() {
        Flux<String> flux = this.testBean.testMethod9("test");
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method9");
            ((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"class", (Object)"TestBean")).containsEntry((Object)"method", (Object)"testMethod9");
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWithLogWhenAnnotationOnInterfaceMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Flux<String> flux = this.testBean.testMethod10("test");
            this.verifyNoSpansUntilFluxComplete(flux);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldStartAndCloseSpanOnContinueSpanIfSpanNotSet() {
        Flux<String> flux = this.testBean.testMethod10("test");
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method10");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWhenKeyIsUsedOnSpanTagWhenAnnotationOnInterfaceMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Flux<String> flux = this.testBean.testMethod10_v2("test");
            this.verifyNoSpansUntilFluxComplete(flux);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWithLogWhenAnnotationOnClassMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Flux<String> flux = this.testBean.testMethod11("test");
            this.verifyNoSpansUntilFluxComplete(flux);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            ((MapAssert)((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"class", (Object)"TestBean")).containsEntry((Object)"method", (Object)"testMethod11")).containsEntry((Object)"customTestTag11", (Object)"test");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldAddErrorTagWhenExceptionOccurredInNewSpan() {
        try {
            Flux<String> flux = this.testBean.testMethod12("test");
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            flux.toIterable().iterator().next();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            FinishedSpan finishedSpan = this.spans.get(0);
            BDDAssertions.then((String)finishedSpan.getName()).isEqualTo("test-method12");
            BDDAssertions.then((Map)finishedSpan.getTags()).containsEntry((Object)"testTag12", (Object)"test");
            BDDAssertions.then((Throwable)finishedSpan.getError()).hasMessageContaining("test exception 12");
            BDDAssertions.then((long)finishedSpan.getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddErrorTagWhenExceptionOccurredInContinueSpan() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            Flux<String> flux = this.testBean.testMethod13();
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            flux.toIterable().iterator().next();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
            BDDAssertions.then((Throwable)this.spans.get(0).getError()).hasMessageContaining("test exception 13");
            BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"testMethod13.before", "testMethod13.afterFailure", "testMethod13.after"});
            BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldNotCreateSpanWhenNotAnnotated() {
        Flux<String> flux = this.testBean.testMethod7();
        this.verifyNoSpansUntilFluxComplete(flux);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).isEmpty();
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldReturnNewSpanFromTraceContext() {
        Flux<String> flux = this.testBean.newSpanInTraceContext();
        String newSpanId = (String)flux.blockFirst();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("span-in-trace-context");
            BDDAssertions.then((String)this.spans.get(0).getSpanId()).isEqualTo(newSpanId);
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    @Test
    public void shouldReturnNewSpanFromSubscriberContext() {
        Flux<String> flux = this.testBean.newSpanInSubscriberContext();
        String newSpanId = (String)flux.blockFirst();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
            BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("span-in-subscriber-context");
            BDDAssertions.then((String)this.spans.get(0).getSpanId()).isEqualTo(newSpanId);
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        });
    }

    private void verifyNoSpansUntilFluxComplete(Flux<String> flux) {
        Iterator iterator = flux.toIterable().iterator();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        this.testBean.proceed();
        String result1 = (String)iterator.next();
        BDDAssertions.then((String)result1).isEqualTo("Test String 1");
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        this.testBean.proceed();
        String result2 = (String)iterator.next();
        BDDAssertions.then((String)result2).isEqualTo("Test String 2");
    }

    protected static class TestBean
    implements TestBeanInterface {
        public static final String TEST_STRING1 = "Test String 1";
        public static final String TEST_STRING2 = "Test String 2";
        private final Tracer tracer;
        private AtomicReference<CompletableFuture<Void>> proceed = new AtomicReference(new CompletableFuture());
        private Flux<String> testFlux = Flux.defer(() -> Flux.just((Object[])new String[]{TEST_STRING1, TEST_STRING2})).delayUntil(s -> Mono.fromFuture(this.proceed.get())).doOnNext(s -> this.proceed.set(new CompletableFuture()));

        public TestBean(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public void reset() {
            this.proceed.set(new CompletableFuture());
        }

        @Override
        public void proceed() {
            this.proceed.get().complete(null);
        }

        @Override
        public Flux<String> testMethod() {
            return this.testFlux;
        }

        @Override
        @NewSpan
        public Flux<String> testMethod2() {
            return this.testFlux;
        }

        @Override
        @NewSpan(name="customNameOnTestMethod3")
        public Flux<String> testMethod3() {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod4() {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod5(String test) {
            return this.testFlux;
        }

        @Override
        @NewSpan(name="customNameOnTestMethod6")
        public Flux<String> testMethod6(@SpanTag(value="testTag6") String test) {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod7() {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod8(String param) {
            return this.testFlux;
        }

        @Override
        @NewSpan(name="customNameOnTestMethod9")
        public Flux<String> testMethod9(String param) {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod10(@SpanTag(value="customTestTag10") String param) {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod10_v2(@SpanTag(key="customTestTag10") String param) {
            return this.testFlux;
        }

        @Override
        @ContinueSpan(log="customTest")
        public Flux<String> testMethod11(@SpanTag(value="customTestTag11") String param) {
            return this.testFlux;
        }

        @Override
        public Flux<String> testMethod12(String param) {
            return Flux.defer(() -> Flux.error((Throwable)new RuntimeException("test exception 12")));
        }

        @Override
        public Flux<String> testMethod13() {
            return Flux.defer(() -> Flux.error((Throwable)new RuntimeException("test exception 13")));
        }

        @Override
        public Flux<String> testMethod14(String param) {
            return Flux.just((Object[])new String[]{TEST_STRING1, TEST_STRING2});
        }

        @Override
        public Flux<String> newSpanInTraceContext() {
            return Flux.defer(() -> Flux.just((Object)SleuthSpanCreatorAspectFluxTests.id(this.tracer)));
        }

        @Override
        public Flux<String> newSpanInSubscriberContext() {
            return Mono.subscriberContext().flatMapMany(context -> Flux.just((Object)SleuthSpanCreatorAspectFluxTests.id(context, this.tracer)));
        }
    }

    protected static interface TestBeanInterface {
        @NewSpan
        public Flux<String> testMethod();

        public Flux<String> testMethod2();

        @NewSpan(name="interfaceCustomNameOnTestMethod3")
        public Flux<String> testMethod3();

        @NewSpan(value="customNameOnTestMethod4")
        public Flux<String> testMethod4();

        @NewSpan(name="customNameOnTestMethod5")
        public Flux<String> testMethod5(@SpanTag(value="testTag") String var1);

        public Flux<String> testMethod6(String var1);

        public Flux<String> testMethod7();

        @NewSpan(name="customNameOnTestMethod8")
        public Flux<String> testMethod8(String var1);

        @NewSpan(name="testMethod9")
        public Flux<String> testMethod9(String var1);

        @ContinueSpan(log="customTest")
        public Flux<String> testMethod10(@SpanTag(value="testTag10") String var1);

        @ContinueSpan(log="customTest")
        public Flux<String> testMethod10_v2(@SpanTag(key="testTag10") String var1);

        @ContinueSpan(log="testMethod11")
        public Flux<String> testMethod11(@SpanTag(value="testTag11") String var1);

        @NewSpan
        public Flux<String> testMethod12(@SpanTag(value="testTag12") String var1);

        @ContinueSpan(log="testMethod13")
        public Flux<String> testMethod13();

        @ContinueSpan
        public Flux<String> testMethod14(String var1);

        @NewSpan(name="spanInTraceContext")
        public Flux<String> newSpanInTraceContext();

        @NewSpan(name="spanInSubscriberContext")
        public Flux<String> newSpanInSubscriberContext();

        public void proceed();

        public void reset();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfiguration {
        @Bean
        public TestBeanInterface testBean(Tracer tracer) {
            return new TestBean(tracer);
        }
    }
}

