/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.instrument.async.TraceableScheduledExecutorService;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.internal.SleuthContextListenerAccessor;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class TraceableScheduledExecutorServiceTest
implements TestTracingAwareSupplier {
    @Mock(lenient=true)
    BeanFactory beanFactory;
    @Mock
    ScheduledExecutorService scheduledExecutorService;
    @InjectMocks
    TraceableScheduledExecutorService traceableScheduledExecutorService;

    @BeforeEach
    public void setup() {
        this.beanFactory();
    }

    @Test
    public void should_schedule_a_trace_runnable() throws Exception {
        this.traceableScheduledExecutorService.schedule(this.aRunnable(), 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should()).schedule((Runnable)BDDMockito.argThat(this.matcher(Runnable.class, this.instanceOf(TraceRunnable.class))), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_schedule_a_trace_callable() throws Exception {
        this.traceableScheduledExecutorService.schedule(this.aCallable(), 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should()).schedule((Callable)BDDMockito.argThat(this.matcher(Callable.class, this.instanceOf(TraceCallable.class))), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_schedule_at_fixed_rate_a_trace_runnable() throws Exception {
        this.traceableScheduledExecutorService.scheduleAtFixedRate(this.aRunnable(), 1L, 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should()).scheduleAtFixedRate((Runnable)BDDMockito.argThat(this.matcher(Runnable.class, this.instanceOf(TraceRunnable.class))), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_schedule_with_fixed_delay_a_trace_runnable() throws Exception {
        this.traceableScheduledExecutorService.scheduleWithFixedDelay(this.aRunnable(), 1L, 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should()).scheduleWithFixedDelay((Runnable)BDDMockito.argThat(this.matcher(Runnable.class, this.instanceOf(TraceRunnable.class))), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_not_schedule_a_trace_runnable_when_context_not_ready() throws Exception {
        SleuthContextListenerAccessor.set(this.beanFactory, false);
        this.traceableScheduledExecutorService.schedule(this.aRunnable(), 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should(Mockito.never())).schedule((Runnable)BDDMockito.argThat(this.matcher(Runnable.class, this.instanceOf(TraceRunnable.class))), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_not_schedule_a_trace_callable_when_context_not_ready() throws Exception {
        SleuthContextListenerAccessor.set(this.beanFactory, false);
        this.traceableScheduledExecutorService.schedule(this.aCallable(), 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should(Mockito.never())).schedule((Callable)BDDMockito.argThat(this.matcher(Callable.class, this.instanceOf(TraceCallable.class))), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_not_schedule_at_fixed_rate_a_trace_runnable_when_context_not_ready() throws Exception {
        SleuthContextListenerAccessor.set(this.beanFactory, false);
        this.traceableScheduledExecutorService.scheduleAtFixedRate(this.aRunnable(), 1L, 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should(Mockito.never())).scheduleAtFixedRate((Runnable)BDDMockito.argThat(this.matcher(Runnable.class, this.instanceOf(TraceRunnable.class))), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void should_not_schedule_with_fixed_delay_a_trace_runnable_when_context_not_ready() throws Exception {
        SleuthContextListenerAccessor.set(this.beanFactory, false);
        this.traceableScheduledExecutorService.scheduleWithFixedDelay(this.aRunnable(), 1L, 1L, TimeUnit.DAYS);
        ((ScheduledExecutorService)BDDMockito.then((Object)this.scheduledExecutorService).should(Mockito.never())).scheduleWithFixedDelay((Runnable)BDDMockito.argThat(this.matcher(Runnable.class, this.instanceOf(TraceRunnable.class))), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    Predicate<Object> instanceOf(Class clazz) {
        return argument -> argument.getClass().isAssignableFrom(clazz);
    }

    <T> ArgumentMatcher<T> matcher(Class<T> clazz, Predicate predicate) {
        return predicate::test;
    }

    Runnable aRunnable() {
        return () -> {};
    }

    Callable<?> aCallable() {
        return () -> null;
    }

    BeanFactory beanFactory() {
        BDDMockito.given((Object)((Tracer)this.beanFactory.getBean(Tracer.class))).willReturn((Object)this.tracerTest().tracing().tracer());
        BDDMockito.given((Object)((SpanNamer)this.beanFactory.getBean(SpanNamer.class))).willReturn((Object)new DefaultSpanNamer());
        SleuthContextListenerAccessor.set(this.beanFactory, true);
        return this.beanFactory;
    }
}

