/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.discoveryexception;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Flux;

@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"spring.application.name=exceptionservice", "spring.sleuth.web.servlet.enabled=false"})
@DirtiesContext
public abstract class WebClientDiscoveryExceptionTests {
    @Autowired
    TestFeignInterfaceWithException testFeignInterfaceWithException;
    @Autowired
    @LoadBalanced
    RestTemplate template;
    @Autowired
    Tracer tracer;
    @Autowired
    TestSpanHandler spans;

    @BeforeEach
    public void close() {
        this.spans.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldCloseSpanUponException(ResponseEntityProvider provider) throws IOException, InterruptedException {
        Span span = this.tracer.nextSpan().name("new trace");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            provider.get(this);
            Assertions.fail((String)"should throw an exception");
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            span.end();
        }
        Thread.sleep(200L);
        BDDAssertions.then((Throwable)this.spans.reportedSpans().stream().filter(span1 -> span1.getKind() == Span.Kind.CLIENT).findFirst().get().getError()).isNotNull();
    }

    @Test
    public void testFeignInterfaceWithException() throws Exception {
        this.shouldCloseSpanUponException(tests -> tests.testFeignInterfaceWithException.shouldFailToConnect());
    }

    @Test
    public void testTemplate() throws Exception {
        this.shouldCloseSpanUponException(tests -> tests.template.getForEntity("https://exceptionservice/", Map.class, new Object[0]));
    }

    @FunctionalInterface
    static interface ResponseEntityProvider {
        public ResponseEntity<?> get(WebClientDiscoveryExceptionTests var1);
    }

    @FeignClient(value="exceptionservice")
    public static interface TestFeignInterfaceWithException {
        @RequestMapping(method={RequestMethod.GET}, value={"/"})
        public ResponseEntity<String> shouldFailToConnect();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableDiscoveryClient
    @EnableFeignClients
    @LoadBalancerClient(value="exceptionservice")
    public static class TestConfiguration {
        @LoadBalanced
        @Bean
        public RestTemplate restTemplate() {
            return new RestTemplate();
        }

        @Bean
        ServiceInstanceListSupplier serviceInstanceListSupplier() {
            return new ServiceInstanceListSupplier(){

                public String getServiceId() {
                    return "exceptionservice";
                }

                public Flux<List<ServiceInstance>> get() {
                    return Flux.just(Collections.singletonList(new ServiceInstance(){

                        public String getServiceId() {
                            return "exceptionservice";
                        }

                        public String getHost() {
                            return "localhost";
                        }

                        public int getPort() {
                            return 1234;
                        }

                        public boolean isSecure() {
                            return false;
                        }

                        public URI getUri() {
                            return null;
                        }

                        public Map<String, String> getMetadata() {
                            return null;
                        }
                    }));
                }
            };
        }
    }
}

