/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Request;
import feign.RequestLine;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class FeignRetriesTests
implements TestTracingAwareSupplier {
    public final MockWebServer server = new MockWebServer();
    @Mock(lenient=true)
    BeanFactory beanFactory;

    @BeforeEach
    void before() throws IOException {
        this.server.start();
    }

    @AfterEach
    void after() throws IOException {
        this.server.close();
    }

    @BeforeEach
    @AfterEach
    public void setup() {
        BDDMockito.given((Object)((CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class))).willReturn((Object)this.tracerTest().tracing().currentTraceContext());
        BDDMockito.given((Object)((HttpClientHandler)this.beanFactory.getBean(HttpClientHandler.class))).willReturn((Object)this.tracerTest().tracing().httpClientHandler());
    }

    @Test
    public void testRetriedWhenExceededNumberOfRetries() {
        Client client = (request, options) -> {
            throw new IOException();
        };
        String url = "http://localhost:" + this.server.getPort();
        TestInterface api = (TestInterface)Feign.builder().client((Client)new TracingFeignClient(this.tracerTest().tracing().currentTraceContext(), this.tracerTest().tracing().httpClientHandler(), client)).target(TestInterface.class, url);
        try {
            api.decodedPost();
            Assertions.failBecauseExceptionWasNotThrown(FeignException.class);
        }
        catch (FeignException feignException) {
            // empty catch block
        }
    }

    @Test
    public void testRetriedWhenRequestEventuallyIsSent() {
        String url = "http://localhost:" + this.server.getPort();
        AtomicInteger atomicInteger = new AtomicInteger();
        Client client = (request, options) -> {
            if (atomicInteger.get() == 1) {
                throw new IOException();
            }
            return Response.builder().status(200).reason("OK").headers(new HashMap()).body("OK", Charset.defaultCharset()).request(Request.create((Request.HttpMethod)Request.HttpMethod.POST, (String)"/foo", new HashMap(), (Request.Body)Request.Body.empty(), (RequestTemplate)new RequestTemplate())).build();
        };
        TestInterface api = (TestInterface)Feign.builder().client((Client)new TracingFeignClient(this.tracerTest().tracing().currentTraceContext(), this.tracerTest().tracing().httpClientHandler(), (request, options) -> {
            atomicInteger.incrementAndGet();
            return client.execute(request, options);
        })).target(TestInterface.class, url);
        BDDAssertions.then((String)api.decodedPost()).isEqualTo("OK");
        BDDAssertions.then((int)atomicInteger.get()).isEqualTo(2);
        this.assertException();
        BDDAssertions.then((Comparable)this.tracerTest().handler().reportedSpans().get(1).getKind()).isEqualTo((Object)Span.Kind.CLIENT);
    }

    public void assertException() {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    static interface TestInterface {
        @RequestLine(value="POST /")
        public String decodedPost();
    }
}

