/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.integration.sampled;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.UnknownHttpStatusCodeException;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;

@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"spring.sleuth.web.servlet.enabled=false", "spring.application.name=fooservice", "spring.sleuth.web.client.skip-pattern=/skip.*"})
@DirtiesContext
public abstract class WebClientTests {
    private static final Log log = LogFactory.getLog(WebClientTests.class);
    @Autowired
    TestFeignInterface testFeignInterface;
    @Autowired
    @LoadBalanced
    RestTemplate template;
    @Autowired
    WebClient webClient;
    @Autowired
    WebClient.Builder webClientBuilder;
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @Autowired
    TestErrorController testErrorController;
    @Autowired
    RestTemplateBuilder restTemplateBuilder;
    @LocalServerPort
    int port;
    @Autowired
    FooController fooController;
    @Autowired
    MyRestTemplateCustomizer customizer;

    @AfterEach
    @BeforeEach
    public void close() {
        this.spans.clear();
        this.testErrorController.clear();
        this.fooController.clear();
    }

    @BeforeEach
    public void setup() {
        log.info((Object)"Starting test");
    }

    @ParameterizedTest
    @MethodSource(value={"parametersForShouldCreateANewSpanWithClientSideTagsWhenNoPreviousTracingWasPresent"})
    public void shouldCreateANewSpanWithClientSideTagsWhenNoPreviousTracingWasPresent(ResponseEntityProvider provider) {
        ResponseEntity response = provider.get(this);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> {
            BDDAssertions.then((String)this.getHeader((ResponseEntity<String>)response, "b3")).isNull();
            BDDAssertions.then((Iterable)this.spans).isNotEmpty();
            Optional<FinishedSpan> noTraceSpan = this.spans.reportedSpans().stream().filter(span -> span.getName().contains("GET") && !span.getTags().isEmpty() && span.getTags().containsKey(this.pathKey())).findFirst();
            BDDAssertions.then((boolean)noTraceSpan.isPresent()).isTrue();
            ((MapAssert)BDDAssertions.then((Map)noTraceSpan.get().getTags()).containsEntry((Object)this.pathKey(), (Object)"/notrace")).containsEntry((Object)"http.method", (Object)"GET");
            BDDAssertions.then((String)((String)noTraceSpan.get().getTags().get(this.pathKey()))).matches((CharSequence)".*/notrace");
        });
        this.thenThereIsNoCurrentSpan();
    }

    protected String pathKey() {
        return "http.path";
    }

    private void thenThereIsNoCurrentSpan() {
        log.info((Object)("Current span [" + this.tracer.currentSpan() + "]"));
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    static Stream parametersForShouldCreateANewSpanWithClientSideTagsWhenNoPreviousTracingWasPresent() {
        return Stream.of(tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.testFeignInterface.getNoTrace(), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]), tests -> tests.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"parametersForShouldAttachTraceIdWhenCallingAnotherService"})
    public void shouldAttachTraceIdWhenCallingAnotherService(ResponseEntityProvider provider) {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            ResponseEntity response = provider.get(this);
            BDDAssertions.then((String)this.getHeader((ResponseEntity<String>)response, "b3")).isNull();
        }
        finally {
            span.end();
        }
        this.thenThereIsNoCurrentSpan();
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAttachTraceIdWhenCallingAnotherServiceViaWebClient() {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            this.webClient.get().uri("http://localhost:" + this.port + "/traceid", new Object[0]).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(5L));
        }
        finally {
            span.end();
        }
        this.thenThereIsNoCurrentSpan();
        ((ListAssert)BDDAssertions.then(this.spans.reportedSpans().stream().filter(r -> r.getKind() != null).map(r -> r.getKind().name()).collect(Collectors.toList())).isNotEmpty()).contains((Object[])new String[]{"CLIENT"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWorkWhenCustomStatusCodeIsReturned() {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            this.webClient.get().uri("http://localhost:" + this.port + "/issue1462", new Object[0]).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(5L));
        }
        catch (UnknownHttpStatusCodeException unknownHttpStatusCodeException) {
        }
        finally {
            span.end();
        }
        this.thenThereIsNoCurrentSpan();
        ((ListAssert)BDDAssertions.then(this.spans.reportedSpans().stream().filter(r -> r.getKind() != null).map(r -> r.getKind().name()).collect(Collectors.toList())).isNotEmpty()).contains((Object[])new String[]{"CLIENT"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseUriTemplateInSpanName() {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            this.webClientBuilder.baseUrl("http://localhost:" + this.port).build().get().uri("/prefix/{variable}/suffix", new Object[]{"value"}).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(5L));
        }
        finally {
            span.end();
        }
        this.thenThereIsNoCurrentSpan();
        ((ListAssert)BDDAssertions.then(this.spans.reportedSpans().stream().filter(r -> r.getKind() == Span.Kind.CLIENT).map(r -> r.getName()).collect(Collectors.toList())).isNotEmpty()).contains((Object[])new String[]{this.templatedName()});
    }

    protected String templatedName() {
        return "GET /prefix/{variable}/suffix";
    }

    @Test
    @Disabled(value="flakey")
    public void shouldNotTagOnCancel() {
        this.webClient.get().uri("http://localhost:" + this.port + "/doNotSkip", new Object[0]).retrieve().bodyToMono(String.class).subscribe((CoreSubscriber)new BaseSubscriber<String>(){

            protected void hookOnSubscribe(Subscription subscription) {
                this.cancel();
            }
        });
        BDDAssertions.then((Iterable)this.spans).isEmpty();
    }

    @Test
    public void shouldRespectSkipPattern() {
        this.webClient.get().uri("http://localhost:" + this.port + "/skip", new Object[0]).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(5L));
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        this.webClient.get().uri("http://localhost:" + this.port + "/doNotSkip", new Object[0]).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(5L));
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
    }

    static Stream parametersForShouldAttachTraceIdWhenCallingAnotherService() {
        return Stream.of(tests -> tests.testFeignInterface.headers(), tests -> tests.template.getForEntity("http://fooservice/traceid", String.class, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"parametersForShouldAttachTraceIdWhenUsingFeignClientWithoutResponseBody"})
    public void shouldAttachTraceIdWhenUsingFeignClientWithoutResponseBody(ResponseEntityProvider provider) {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            provider.get(this);
        }
        finally {
            span.end();
        }
        this.thenThereIsNoCurrentSpan();
        BDDAssertions.then((Iterable)this.spans).isNotEmpty();
    }

    static Stream parametersForShouldAttachTraceIdWhenUsingFeignClientWithoutResponseBody() {
        return Stream.of(tests -> tests.testFeignInterface.noResponseBody(), tests -> tests.template.getForEntity("http://fooservice/noresponse", String.class, new Object[0]));
    }

    @Test
    public void shouldCloseSpanWhenErrorControllerGetsCalled() {
        try {
            this.template.getForEntity("http://fooservice/nonExistent", String.class, new Object[0]);
            Assertions.fail((String)"An exception should be thrown");
        }
        catch (HttpClientErrorException httpClientErrorException) {
            // empty catch block
        }
        this.thenThereIsNoCurrentSpan();
        Optional<FinishedSpan> storedSpan = this.spans.reportedSpans().stream().filter(span -> "404".equals(span.getTags().get("http.status_code"))).findFirst();
        BDDAssertions.then((boolean)storedSpan.isPresent()).isTrue();
        this.spans.reportedSpans().stream().forEach(span -> {
            int initialSize = span.getEvents().size();
            int distinctSize = span.getEvents().stream().map(Map.Entry::getValue).distinct().collect(Collectors.toList()).size();
            log.info((Object)("logs " + span.getEvents()));
            ((AbstractIntegerAssert)BDDAssertions.then((int)initialSize).as("there are no duplicate log entries", new Object[0])).isEqualTo(distinctSize);
        });
        ((ListAssert)BDDAssertions.then(this.spans.reportedSpans().stream().filter(r -> r.getKind() != null).map(r -> r.getKind().name()).collect(Collectors.toList())).isNotEmpty()).contains((Object[])new String[]{"CLIENT"});
    }

    @Test
    public void shouldNotExecuteErrorControllerWhenUrlIsFound() {
        this.template.getForEntity("http://fooservice/notrace", String.class, new Object[0]);
        this.thenThereIsNoCurrentSpan();
        BDDAssertions.then((Object)this.testErrorController.getSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_wrap_rest_template_builders() {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            RestTemplate template = this.restTemplateBuilder.build();
            template.getForObject("http://localhost:" + this.port + "/traceid", String.class, new Object[0]);
        }
        finally {
            span.end();
        }
        this.thenThereIsNoCurrentSpan();
        BDDAssertions.then((boolean)this.customizer.isExecuted()).isTrue();
        BDDAssertions.then(this.spans.reportedSpans().stream().filter(s -> s.getKind() != null).map(s -> s.getKind().name()).collect(Collectors.toList())).contains((Object[])new String[]{"CLIENT"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_add_headers_eagerly() {
        Span span = this.tracer.nextSpan().name("foo").start();
        AtomicReference traceId = new AtomicReference();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            this.webClientBuilder.filter((request, exchange) -> {
                traceId.set(request.headers().getFirst("b3"));
                return exchange.exchange(request);
            }).build().get().uri("http://localhost:" + this.port + "/traceid", new Object[0]).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(5L));
        }
        finally {
            span.end();
        }
        BDDAssertions.then(traceId).doesNotHaveValue(null);
    }

    private String getHeader(ResponseEntity<String> response, String name) {
        List headers = response.getHeaders().get((Object)name);
        return headers == null || headers.isEmpty() ? null : (String)headers.get(0);
    }

    public static class TestErrorController
    extends BasicErrorController {
        private final Tracer tracer;
        Span span;

        public TestErrorController(ErrorAttributes errorAttributes, Tracer tracer) {
            super(errorAttributes, new ServerProperties().getError());
            this.tracer = tracer;
        }

        public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
            this.span = this.tracer.currentSpan();
            return super.error(request);
        }

        public Span getSpan() {
            return this.span;
        }

        public void clear() {
            this.span = null;
        }
    }

    @RestController
    public static class FooController {
        Span span;

        @RequestMapping(value={"/notrace"}, method={RequestMethod.GET})
        public String notrace(@RequestHeader(name="b3", required=false) String b3Single) {
            BDDAssertions.then((String)b3Single).isNotNull();
            return "OK";
        }

        @RequestMapping(value={"/traceid"}, method={RequestMethod.GET})
        public String traceId(@RequestHeader(value="b3") String b3Single) {
            BDDAssertions.then((String)b3Single).isNotEmpty();
            return b3Single;
        }

        @RequestMapping(value={"/"})
        public Map<String, String> home(@RequestHeader HttpHeaders headers) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : headers.keySet()) {
                map.put(key, headers.getFirst(key));
            }
            return map;
        }

        @RequestMapping(value={"/noresponse"})
        public void noResponse(@RequestHeader(value="b3") String b3Single) {
            BDDAssertions.then((String)b3Single).isNotEmpty();
        }

        public Span getSpan() {
            return this.span;
        }

        public void clear() {
            this.span = null;
        }
    }

    @FunctionalInterface
    static interface ResponseEntityProvider {
        public ResponseEntity get(WebClientTests var1);
    }

    static class MyRestTemplateCustomizer
    implements RestTemplateCustomizer {
        boolean executed;

        MyRestTemplateCustomizer() {
        }

        public void customize(RestTemplate restTemplate) {
            this.executed = true;
        }

        public boolean isExecuted() {
            return this.executed;
        }
    }

    @FeignClient(value="fooservice")
    public static interface TestFeignInterface {
        @RequestMapping(method={RequestMethod.GET}, value={"/traceid"})
        public ResponseEntity<String> getTraceId();

        @RequestMapping(method={RequestMethod.GET}, value={"/notrace"})
        public ResponseEntity<String> getNoTrace();

        @RequestMapping(method={RequestMethod.GET}, value={"/"})
        public ResponseEntity<Map<String, String>> headers();

        @RequestMapping(method={RequestMethod.GET}, value={"/noresponse"})
        public ResponseEntity<Void> noResponseBody();
    }

    @Configuration(proxyBeanMethods=false)
    public static class SimpleLoadBalancerClientConfiguration {
        @Value(value="${local.server.port}")
        private int port = 0;

        @Bean
        public ServiceInstanceListSupplier serviceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)"fooservice", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("fooservice-1", "fooservice", "localhost", this.port, false)});
        }
    }

    @RestController
    public static class WebClientController {
        @RequestMapping(value={"/issue1462"}, method={RequestMethod.GET})
        public ResponseEntity<String> issue1462() {
            return ResponseEntity.status((int)499).body((Object)"issue1462");
        }

        @RequestMapping(value={"/skip", "/doNotSkip"}, method={RequestMethod.GET})
        String skip() {
            return "ok";
        }

        @RequestMapping(value={"/prefix/{variable}/suffix"}, method={RequestMethod.GET})
        String pathVariable(@PathVariable(value="variable") String variable) {
            return "variable = " + variable;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration(exclude={JmxAutoConfiguration.class})
    @EnableFeignClients
    @LoadBalancerClient(value="fooservice", configuration={SimpleLoadBalancerClientConfiguration.class})
    public static class TestConfiguration {
        @Bean
        FooController fooController() {
            return new FooController();
        }

        @Bean
        WebClientController webClientController() {
            return new WebClientController();
        }

        @LoadBalanced
        @Bean
        public RestTemplate restTemplate() {
            return new RestTemplate();
        }

        @Bean
        TestErrorController testErrorController(ErrorAttributes errorAttributes, Tracer tracer) {
            return new TestErrorController(errorAttributes, tracer);
        }

        @Bean
        WebClient webClient() {
            return WebClient.builder().build();
        }

        @Bean
        WebClient.Builder webClientBuilder() {
            return WebClient.builder();
        }

        @Bean
        RestTemplateCustomizer myRestTemplateCustomizer() {
            return new MyRestTemplateCustomizer();
        }
    }
}

