/*
 * Copyright 2013-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.sleuth.zipkin2;

import java.net.URI;

/**
 * Provides a way to retrieve Zipkin URI. If there's no discovery client then this value
 * will be taken from the properties. Otherwise host will be assumed to be a service id.
 *
 * @author Marcin Grzejszczak
 * @since 3.0.0
 */
public interface ZipkinUrlExtractor {

	URI zipkinUrl(ZipkinProperties zipkinProperties);

}
