/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.springframework.messaging.MessageChannel;

public class SharedChannelRegistry {
    private Map<String, MessageChannel> sharedChannels = new ConcurrentSkipListMap<String, MessageChannel>(String.CASE_INSENSITIVE_ORDER);

    public MessageChannel get(String id) {
        return this.sharedChannels.get(id);
    }

    public void register(String id, MessageChannel messageChannel) {
        this.sharedChannels.put(id, messageChannel);
    }

    public Map<String, MessageChannel> getAll() {
        return Collections.unmodifiableMap(this.sharedChannels);
    }
}

