/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.aggregate.SharedChannelRegistry;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindableChannelFactory;
import org.springframework.cloud.stream.binding.BindingBeanDefinitionRegistryUtils;
import org.springframework.cloud.stream.binding.ChannelBindingService;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BindableProxyFactory
implements MethodInterceptor,
FactoryBean<Object>,
Bindable,
InitializingBean {
    private static Log log = LogFactory.getLog(BindableProxyFactory.class);
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    private static final String CHANNEL_NAMESPACE_PROPERTY_NAME = "spring.cloud.stream.internal.channelNamespace";
    @Value(value="${spring.cloud.stream.internal.channelNamespace:}")
    private String channelNamespace;
    @Autowired
    private BindableChannelFactory channelFactory;
    @Autowired(required=false)
    private SharedChannelRegistry sharedChannelRegistry;
    private Class<?> type;
    private Object proxy = null;
    private Map<String, ChannelHolder> inputHolders = new HashMap<String, ChannelHolder>();
    private Map<String, ChannelHolder> outputHolders = new HashMap<String, ChannelHolder>();

    public BindableProxyFactory(Class<?> type) {
        this.type = type;
    }

    public synchronized Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (MessageChannel.class.isAssignableFrom(method.getReturnType())) {
            Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
            if (input != null) {
                String name = BindingBeanDefinitionRegistryUtils.getChannelName(input, method);
                return this.inputHolders.get(name).getMessageChannel();
            }
            Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
            if (output != null) {
                String name = BindingBeanDefinitionRegistryUtils.getChannelName(output, method);
                return this.outputHolders.get(name).getMessageChannel();
            }
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        ReflectionUtils.doWithMethods(this.type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Assert.notNull((Object)BindableProxyFactory.this.channelFactory, (String)"Channel Factory cannot be null");
                Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
                if (input != null) {
                    String name = BindingBeanDefinitionRegistryUtils.getChannelName(input, method);
                    BindableProxyFactory.this.validateChannelType(method.getReturnType());
                    MessageChannel sharedChannel = BindableProxyFactory.this.locateSharedChannel(name);
                    if (sharedChannel == null) {
                        BindableProxyFactory.this.inputHolders.put(name, new ChannelHolder((MessageChannel)BindableProxyFactory.this.channelFactory.createSubscribableChannel(name), true));
                    } else {
                        BindableProxyFactory.this.inputHolders.put(name, new ChannelHolder(sharedChannel, false));
                    }
                }
            }
        });
        ReflectionUtils.doWithMethods(this.type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
                if (output != null) {
                    String name = BindingBeanDefinitionRegistryUtils.getChannelName(output, method);
                    BindableProxyFactory.this.validateChannelType(method.getReturnType());
                    MessageChannel sharedChannel = BindableProxyFactory.this.locateSharedChannel(name);
                    if (sharedChannel == null) {
                        BindableProxyFactory.this.outputHolders.put(name, new ChannelHolder((MessageChannel)BindableProxyFactory.this.channelFactory.createSubscribableChannel(name), true));
                    } else {
                        BindableProxyFactory.this.outputHolders.put(name, new ChannelHolder(sharedChannel, false));
                    }
                }
            }
        });
    }

    private void validateChannelType(Class<?> channelType) {
        Assert.isTrue((SubscribableChannel.class.equals(channelType) || MessageChannel.class.equals(channelType) ? 1 : 0) != 0, (String)("A bound channel should be either a '" + MessageChannel.class.getName() + "', " + " or a '" + SubscribableChannel.class.getName() + "'"));
    }

    private MessageChannel locateSharedChannel(String name) {
        return this.sharedChannelRegistry != null ? this.sharedChannelRegistry.get(this.getNamespacePrefixedChannelName(name)) : null;
    }

    private String getNamespacePrefixedChannelName(String name) {
        return this.channelNamespace + "." + name;
    }

    public synchronized Object getObject() throws Exception {
        if (this.proxy == null) {
            ProxyFactory factory = new ProxyFactory(this.type, (Interceptor)this);
            this.proxy = factory.getProxy();
        }
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public void bindInputs(ChannelBindingService channelBindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Binding inputs for %s:%s", this.channelNamespace, this.type));
        }
        for (Map.Entry<String, ChannelHolder> channelHolderEntry : this.inputHolders.entrySet()) {
            String inputChannelName = channelHolderEntry.getKey();
            ChannelHolder channelHolder = channelHolderEntry.getValue();
            if (!channelHolder.isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.channelNamespace, this.type, inputChannelName));
            }
            channelBindingService.bindConsumer(channelHolder.getMessageChannel(), inputChannelName);
        }
    }

    @Override
    public void bindOutputs(ChannelBindingService channelBindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Binding outputs for %s:%s", this.channelNamespace, this.type));
        }
        for (Map.Entry<String, ChannelHolder> channelHolderEntry : this.outputHolders.entrySet()) {
            ChannelHolder channelHolder = channelHolderEntry.getValue();
            String outputChannelName = channelHolderEntry.getKey();
            if (!channelHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.channelNamespace, this.type, outputChannelName));
            }
            channelBindingService.bindProducer(channelHolder.getMessageChannel(), outputChannelName);
        }
    }

    @Override
    public void unbindInputs(ChannelBindingService channelBindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unbinding inputs for %s:%s", this.channelNamespace, this.type));
        }
        for (Map.Entry<String, ChannelHolder> channelHolderEntry : this.inputHolders.entrySet()) {
            if (!channelHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unbinding %s:%s:%s", this.channelNamespace, this.type, channelHolderEntry.getKey()));
            }
            channelBindingService.unbindConsumers(channelHolderEntry.getKey());
        }
    }

    @Override
    public void unbindOutputs(ChannelBindingService channelBindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unbinding outputs for %s:%s", this.channelNamespace, this.type));
        }
        for (Map.Entry<String, ChannelHolder> channelHolderEntry : this.outputHolders.entrySet()) {
            if (!channelHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.channelNamespace, this.type, channelHolderEntry.getKey()));
            }
            channelBindingService.unbindProducers(channelHolderEntry.getKey());
        }
    }

    @Override
    public Set<String> getInputs() {
        return this.inputHolders.keySet();
    }

    @Override
    public Set<String> getOutputs() {
        return this.outputHolders.keySet();
    }

    class ChannelHolder {
        private MessageChannel messageChannel;
        private boolean bindable;

        public ChannelHolder(MessageChannel messageChannel, boolean bindable) {
            this.messageChannel = messageChannel;
            this.bindable = bindable;
        }

        public MessageChannel getMessageChannel() {
            return this.messageChannel;
        }

        public boolean isBindable() {
            return this.bindable;
        }
    }
}

