/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.binder.DefaultBinderTypeRegistry;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.ChannelBindingAutoConfiguration;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class BinderFactoryConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BinderFactory.class})
    public BinderFactory<?> binderFactory(BinderTypeRegistry binderTypeRegistry, ChannelBindingServiceProperties channelBindingServiceProperties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map<String, BinderProperties> declaredBinders = channelBindingServiceProperties.getBinders();
        boolean defaultCandidatesExist = false;
        Iterator<Map.Entry<String, BinderProperties>> binderPropertiesIterator = declaredBinders.entrySet().iterator();
        while (!defaultCandidatesExist && binderPropertiesIterator.hasNext()) {
            defaultCandidatesExist = binderPropertiesIterator.next().getValue().isDefaultCandidate();
        }
        for (Map.Entry<String, BinderProperties> entry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = entry.getValue();
            if (binderTypeRegistry.get(entry.getKey()) != null) {
                binderConfigurations.put(entry.getKey(), new BinderConfiguration(binderTypeRegistry.get(entry.getKey()), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
                continue;
            }
            Assert.hasText((String)binderProperties.getType(), (String)("No 'type' property present for custom binder " + entry.getKey()));
            BinderType binderType = binderTypeRegistry.get(binderProperties.getType());
            Assert.notNull((Object)binderType, (String)("Binder type " + binderProperties.getType() + " is not defined"));
            binderConfigurations.put(entry.getKey(), new BinderConfiguration(binderType, binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
        }
        if (!defaultCandidatesExist) {
            for (Map.Entry<String, Object> entry : binderTypeRegistry.getAll().entrySet()) {
                binderConfigurations.put(entry.getKey(), new BinderConfiguration((BinderType)entry.getValue(), new Properties(), true, true));
            }
        }
        DefaultBinderFactory binderFactory = new DefaultBinderFactory(binderConfigurations);
        binderFactory.setDefaultBinder(channelBindingServiceProperties.getDefaultBinder());
        return binderFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={BinderTypeRegistry.class})
    public BinderTypeRegistry binderTypeRegistry(ConfigurableApplicationContext configurableApplicationContext) {
        HashMap<String, BinderType> binderTypes = new HashMap<String, BinderType>();
        ClassLoader classLoader = configurableApplicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = ChannelBindingAutoConfiguration.class.getClassLoader();
        }
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/spring.binders");
            if (resources == null || !resources.hasMoreElements()) {
                throw new BeanCreationException("Cannot create binder factory, no `META-INF/spring.binders` resources found on the classpath");
            }
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                UrlResource resource = new UrlResource(url);
                for (BinderType binderType : BinderFactoryConfiguration.parseBinderConfigurations(classLoader, (Resource)resource)) {
                    binderTypes.put(binderType.getDefaultName(), binderType);
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BeanCreationException("Cannot create binder factory:", (Throwable)e);
        }
        return new DefaultBinderTypeRegistry(binderTypes);
    }

    static Collection<BinderType> parseBinderConfigurations(ClassLoader classLoader, Resource resource) throws IOException, ClassNotFoundException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        ArrayList<BinderType> parsedBinderConfigurations = new ArrayList<BinderType>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String binderType = (String)entry.getKey();
            String[] binderConfigurationClassNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()));
            Class[] binderConfigurationClasses = new Class[binderConfigurationClassNames.length];
            int i = 0;
            for (String binderConfigurationClassName : binderConfigurationClassNames) {
                binderConfigurationClasses[i++] = ClassUtils.forName((String)binderConfigurationClassName, (ClassLoader)classLoader);
            }
            parsedBinderConfigurations.add(new BinderType(binderType, binderConfigurationClasses));
        }
        return parsedBinderConfigurations;
    }
}

