/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.MutableMessageBuilderFactory;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.tuple.Tuple;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class MessageConverterConfigurer
implements MessageChannelConfigurer,
BeanFactoryAware,
InitializingBean {
    private final MessageBuilderFactory messageBuilderFactory = new MutableMessageBuilderFactory();
    private ConfigurableListableBeanFactory beanFactory;
    private final CompositeMessageConverterFactory compositeMessageConverterFactory;
    private final ChannelBindingServiceProperties channelBindingServiceProperties;

    public MessageConverterConfigurer(ChannelBindingServiceProperties channelBindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        Assert.notNull((Object)compositeMessageConverterFactory, (String)"The message converter factory cannot be null");
        this.channelBindingServiceProperties = channelBindingServiceProperties;
        this.compositeMessageConverterFactory = compositeMessageConverterFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"Bean factory cannot be empty");
    }

    @Override
    public void configureInputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, true);
    }

    @Override
    public void configureOutputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, false);
    }

    private void configureMessageChannel(MessageChannel channel, String channelName, boolean input) {
        Assert.isAssignable(AbstractMessageChannel.class, channel.getClass());
        AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
        BindingProperties bindingProperties = this.channelBindingServiceProperties.getBindingProperties(channelName);
        String contentType = bindingProperties.getContentType();
        if (!input && bindingProperties.getProducer() != null && bindingProperties.getProducer().isPartitioned()) {
            messageChannel.addInterceptor((ChannelInterceptor)new PartitioningInterceptor(bindingProperties));
        }
        if (StringUtils.hasText((String)contentType)) {
            messageChannel.addInterceptor((ChannelInterceptor)new ContentTypeConvertingInterceptor(contentType, input));
        }
    }

    private final class PartitioningInterceptor
    extends ChannelInterceptorAdapter {
        private final BindingProperties bindingProperties;

        private PartitioningInterceptor(BindingProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)MessageConverterConfigurer.this.beanFactory);
            PartitionHandler partitionHandler = new PartitionHandler(MessageConverterConfigurer.this.beanFactory, (EvaluationContext)evaluationContext, null, this.bindingProperties.getProducer());
            int partition = partitionHandler.determinePartition(message);
            return new MutableMessageBuilderFactory().fromMessage(message).setHeader("partition", (Object)partition).build();
        }
    }

    private final class ContentTypeConvertingInterceptor
    extends ChannelInterceptorAdapter {
        private final String contentType;
        private final MimeType mimeType;
        private final boolean input;
        private final Class<?> klazz;
        private final MessageConverter messageConverter;
        private final boolean provideHint;

        private ContentTypeConvertingInterceptor(String contentType, boolean input) {
            this.contentType = contentType;
            this.mimeType = MessageConverterUtils.getMimeType(contentType);
            this.input = input;
            this.klazz = MessageConverterUtils.X_JAVA_OBJECT.includes(this.mimeType) ? MessageConverterUtils.getJavaTypeForJavaObjectContentType(this.mimeType) : (this.mimeType.equals((Object)MessageConverterUtils.X_SPRING_TUPLE) ? Tuple.class : (this.mimeType.getType().equals("text") || this.mimeType.getSubtype().equals("json") || this.mimeType.getSubtype().equals("xml") ? String.class : byte[].class));
            this.messageConverter = MessageConverterConfigurer.this.compositeMessageConverterFactory.getMessageConverterForType(this.mimeType);
            this.provideHint = this.messageConverter instanceof AbstractMessageConverter;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            Message sentMessage = null;
            if (this.klazz.isAssignableFrom(message.getPayload().getClass())) {
                Object contentTypeFromMessage = message.getHeaders().get((Object)"contentType");
                sentMessage = contentTypeFromMessage == null ? MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("contentType", (Object)this.contentType).build() : message;
            } else {
                Object converted = this.input ? (this.provideHint ? ((AbstractMessageConverter)this.messageConverter).fromMessage(message, this.klazz, (Object)this.mimeType) : this.messageConverter.fromMessage(message, this.klazz)) : (this.provideHint ? ((AbstractMessageConverter)this.messageConverter).toMessage(message.getPayload(), (MessageHeaders)new MutableMessageHeaders((Map)message.getHeaders()), (Object)this.mimeType) : this.messageConverter.toMessage(message.getPayload(), (MessageHeaders)new MutableMessageHeaders((Map)message.getHeaders())));
                sentMessage = converted instanceof Message ? (Message)converted : MessageConverterConfigurer.this.messageBuilderFactory.withPayload(converted).copyHeaders((Map)message.getHeaders()).setHeaderIfAbsent("contentType", (Object)this.mimeType).build();
            }
            if (sentMessage == null) {
                throw new MessageConversionException("Cannot convert " + message + " to " + this.contentType);
            }
            return sentMessage;
        }
    }
}

