/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.config.SpelExpressionConverterConfiguration;
import org.springframework.cloud.stream.reflection.GenericsUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultBinderFactory
implements BinderFactory,
DisposableBean,
ApplicationContextAware {
    private final Map<String, BinderConfiguration> binderConfigurations;
    private final Map<String, Map.Entry<Binder<?, ?, ?>, ConfigurableApplicationContext>> binderInstanceCache = new HashMap();
    private volatile ConfigurableApplicationContext context;
    private final Map<String, String> defaultBinderForBindingTargetType = new HashMap<String, String>();
    private Collection<Listener> listeners;
    private volatile String defaultBinder;
    private final BinderTypeRegistry binderTypeRegistry;

    public DefaultBinderFactory(Map<String, BinderConfiguration> binderConfigurations, BinderTypeRegistry binderTypeRegistry) {
        this.binderConfigurations = new HashMap<String, BinderConfiguration>(binderConfigurations);
        this.binderTypeRegistry = binderTypeRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public void setListeners(Collection<Listener> listeners) {
        this.listeners = listeners;
    }

    public void destroy() throws Exception {
        this.binderInstanceCache.values().stream().map(e -> (ConfigurableApplicationContext)e.getValue()).forEach(ctx -> ctx.close());
        this.defaultBinderForBindingTargetType.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized <T> Binder<T, ?, ?> getBinder(String name, Class<? extends T> bindingTargetType) {
        String configurationName;
        if (StringUtils.isEmpty((Object)name)) {
            Assert.notEmpty(this.binderConfigurations, (String)"A default binder has been requested, but there is no binder available");
            if (!StringUtils.hasText((String)this.defaultBinder)) {
                HashSet<String> defaultCandidateConfigurations = new HashSet<String>();
                for (Map.Entry<String, BinderConfiguration> binderConfigurationEntry : this.binderConfigurations.entrySet()) {
                    if (!binderConfigurationEntry.getValue().isDefaultCandidate()) continue;
                    defaultCandidateConfigurations.add(binderConfigurationEntry.getKey());
                }
                if (defaultCandidateConfigurations.size() == 1) {
                    configurationName = (String)defaultCandidateConfigurations.iterator().next();
                    this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                } else {
                    ArrayList<String> candidatesForBindableType = new ArrayList<String>();
                    for (String defaultCandidateConfiguration : defaultCandidateConfigurations) {
                        Binder<T, ?, ?> binderInstance = this.getBinderInstance(defaultCandidateConfiguration);
                        Class<T> binderType = GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0);
                        if (!binderType.isAssignableFrom(bindingTargetType)) continue;
                        candidatesForBindableType.add(defaultCandidateConfiguration);
                    }
                    if (candidatesForBindableType.size() != 1) throw new IllegalStateException("A default binder has been requested, but there is more than one binder available for '" + bindingTargetType.getName() + "' : " + StringUtils.collectionToCommaDelimitedString(candidatesForBindableType) + ", and no default binder has been set.");
                    configurationName = (String)candidatesForBindableType.iterator().next();
                    this.defaultBinderForBindingTargetType.put(bindingTargetType.getName(), configurationName);
                }
            } else {
                configurationName = this.defaultBinder;
            }
        } else {
            configurationName = name;
        }
        Binder<T, ?, ?> binderInstance = this.getBinderInstance(configurationName);
        Assert.state((boolean)this.verifyBinderTypeMatchesTarget(binderInstance, bindingTargetType), (String)("The binder '" + configurationName + "' cannot bind a " + bindingTargetType.getName()));
        return binderInstance;
    }

    private <T> boolean verifyBinderTypeMatchesTarget(Binder<T, ?, ?> binderInstance, Class<? extends T> bindingTargetType) {
        return binderInstance instanceof PollableConsumerBinder && GenericsUtils.checkCompatiblePollableBinder(binderInstance, bindingTargetType) || GenericsUtils.getParameterType(binderInstance.getClass(), Binder.class, 0).isAssignableFrom(bindingTargetType);
    }

    private <T> Binder<T, ?, ?> getBinderInstance(String configurationName) {
        if (!this.binderInstanceCache.containsKey(configurationName)) {
            boolean useApplicationContextAsParent;
            BinderConfiguration binderConfiguration = this.binderConfigurations.get(configurationName);
            Assert.state((binderConfiguration != null ? 1 : 0) != 0, (String)("Unknown binder configuration: " + configurationName));
            BinderType binderType = this.binderTypeRegistry.get(binderConfiguration.getBinderType());
            Assert.notNull((Object)binderType, (String)("Binder type " + binderConfiguration.getBinderType() + " is not defined"));
            HashMap<String, String> binderProperties = new HashMap<String, String>();
            this.flatten(null, binderConfiguration.getProperties(), binderProperties);
            ArrayList<String> args = new ArrayList<String>();
            for (Map.Entry property : binderProperties.entrySet()) {
                args.add(String.format("--%s=%s", property.getKey(), property.getValue()));
            }
            ConfigurableEnvironment environment = this.context != null ? this.context.getEnvironment() : null;
            String defaultDomain = environment != null ? environment.getProperty("spring.jmx.default-domain") : "";
            args.add("--spring.jmx.default-domain=" + defaultDomain + "binder." + configurationName);
            SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Class[]{SpelExpressionConverterConfiguration.class}).sources((Class[])binderType.getConfigurationClasses()).bannerMode(Banner.Mode.OFF).logStartupInfo(false).web(WebApplicationType.NONE);
            boolean bl = useApplicationContextAsParent = binderProperties.isEmpty() && this.context != null;
            if (useApplicationContextAsParent) {
                springApplicationBuilder.parent(this.context);
            }
            if (environment != null && (useApplicationContextAsParent || binderConfiguration.isInheritEnvironment())) {
                StandardEnvironment binderEnvironment = new StandardEnvironment();
                binderEnvironment.merge(environment);
                springApplicationBuilder.environment((ConfigurableEnvironment)binderEnvironment);
            }
            ConfigurableApplicationContext binderProducingContext = springApplicationBuilder.run(args.toArray(new String[args.size()]));
            Binder binder = (Binder)binderProducingContext.getBean(Binder.class);
            if (this.context != null && binder instanceof ApplicationContextAware) {
                ((ApplicationContextAware)binder).setApplicationContext((ApplicationContext)this.context);
            }
            if (!CollectionUtils.isEmpty(this.listeners)) {
                for (Listener binderFactoryListener : this.listeners) {
                    binderFactoryListener.afterBinderContextInitialized(configurationName, binderProducingContext);
                }
            }
            this.binderInstanceCache.put(configurationName, new AbstractMap.SimpleImmutableEntry<Binder, ConfigurableApplicationContext>(binder, binderProducingContext));
        }
        return this.binderInstanceCache.get(configurationName).getKey();
    }

    private void flatten(String propertyName, Object value, Map<String, String> flattenedProperties) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.flatten((propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    public static interface Listener {
        public void afterBinderContextInitialized(String var1, ConfigurableApplicationContext var2);
    }
}

