/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.DynamicDestinationsBindable;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.integration.config.GlobalChannelInterceptorProcessor;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BinderAwareChannelResolver
extends BeanFactoryMessageChannelDestinationResolver {
    private final Log logger = LogFactory.getLog(BinderAwareChannelResolver.class);
    private final BindingService bindingService;
    private final AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory;
    private final DynamicDestinationsBindable dynamicDestinationsBindable;
    private final NewDestinationBindingCallback newBindingCallback;
    private ConfigurableListableBeanFactory beanFactory;
    private final GlobalChannelInterceptorProcessor globalChannelInterceptorProcessor;

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable) {
        this(bindingService, bindingTargetFactory, dynamicDestinationsBindable, null, null);
    }

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable, NewDestinationBindingCallback callback) {
        this(bindingService, bindingTargetFactory, dynamicDestinationsBindable, callback, null);
    }

    public BinderAwareChannelResolver(BindingService bindingService, AbstractBindingTargetFactory<? extends MessageChannel> bindingTargetFactory, DynamicDestinationsBindable dynamicDestinationsBindable, NewDestinationBindingCallback callback, GlobalChannelInterceptorProcessor globalChannelInterceptorProcessor) {
        this.dynamicDestinationsBindable = dynamicDestinationsBindable;
        Assert.notNull((Object)bindingService, (String)"'bindingService' cannot be null");
        Assert.notNull(bindingTargetFactory, (String)"'bindingTargetFactory' cannot be null");
        this.bindingService = bindingService;
        this.bindingTargetFactory = bindingTargetFactory;
        this.newBindingCallback = callback;
        this.globalChannelInterceptorProcessor = globalChannelInterceptorProcessor;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        Assert.isTrue((boolean)(beanFactory instanceof ConfigurableListableBeanFactory), (String)"'beanFactory' must be an instance of ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel resolveDestination(String channelName) {
        try {
            return super.resolveDestination(channelName);
        }
        catch (DestinationResolutionException destinationResolutionException) {
            BinderAwareChannelResolver binderAwareChannelResolver = this;
            synchronized (binderAwareChannelResolver) {
                BindingServiceProperties bindingServiceProperties = this.bindingService.getBindingServiceProperties();
                Object[] dynamicDestinations = bindingServiceProperties.getDynamicDestinations();
                boolean dynamicAllowed = ObjectUtils.isEmpty((Object[])dynamicDestinations) || ObjectUtils.containsElement((Object[])dynamicDestinations, (Object)channelName);
                try {
                    return super.resolveDestination(channelName);
                }
                catch (DestinationResolutionException e) {
                    if (!dynamicAllowed) {
                        throw e;
                    }
                    MessageChannel channel = this.bindingTargetFactory.createOutput(channelName);
                    this.beanFactory.registerSingleton(channelName, (Object)channel);
                    this.instrumentChannelWithGlobalInterceptors(channel, channelName);
                    channel = (MessageChannel)this.beanFactory.initializeBean((Object)channel, channelName);
                    if (this.newBindingCallback != null) {
                        ProducerProperties producerProperties = bindingServiceProperties.getProducerProperties(channelName);
                        Object extendedProducerProperties = this.bindingService.getExtendedProducerProperties(channel, channelName);
                        this.newBindingCallback.configure(channelName, channel, producerProperties, extendedProducerProperties);
                        bindingServiceProperties.updateProducerProperties(channelName, producerProperties);
                    }
                    Binding<MessageChannel> binding = this.bindingService.bindProducer(channel, channelName);
                    this.dynamicDestinationsBindable.addOutputBinding(channelName, binding);
                    return channel;
                }
            }
        }
    }

    private void instrumentChannelWithGlobalInterceptors(MessageChannel channel, String channelName) {
        if (channel instanceof ChannelInterceptorAware) {
            if (this.globalChannelInterceptorProcessor != null) {
                this.globalChannelInterceptorProcessor.addMatchingInterceptors((ChannelInterceptorAware)channel, channelName);
            }
        } else {
            this.logger.warn((Object)("Failed to add global interceptors to '" + channelName + "' since it is not an instance of ChannelInterceptorAware."));
        }
    }

    @FunctionalInterface
    public static interface NewDestinationBindingCallback<T> {
        public void configure(String var1, MessageChannel var2, ProducerProperties var3, T var4);
    }
}

