/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class StreamListenerMethodUtils {
    protected static int inputAnnotationCount(Method method) {
        int inputAnnotationCount = 0;
        for (int parameterIndex = 0; parameterIndex < method.getParameterTypes().length; ++parameterIndex) {
            MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
            if (!methodParameter.hasParameterAnnotation(Input.class)) continue;
            ++inputAnnotationCount;
        }
        return inputAnnotationCount;
    }

    protected static int outputAnnotationCount(Method method) {
        int outputAnnotationCount = 0;
        for (int parameterIndex = 0; parameterIndex < method.getParameterTypes().length; ++parameterIndex) {
            MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
            if (!methodParameter.hasParameterAnnotation(Output.class)) continue;
            ++outputAnnotationCount;
        }
        return outputAnnotationCount;
    }

    protected static void validateStreamListenerMethod(Method method, int inputAnnotationCount, int outputAnnotationCount, String methodAnnotatedInboundName, String methodAnnotatedOutboundName, boolean isDeclarative, String condition) {
        int methodArgumentsLength = method.getParameterTypes().length;
        if (!isDeclarative) {
            Assert.isTrue((inputAnnotationCount == 0 && outputAnnotationCount == 0 ? 1 : 0) != 0, (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
        }
        if (StringUtils.hasText((String)methodAnnotatedInboundName) && StringUtils.hasText((String)methodAnnotatedOutboundName)) {
            Assert.isTrue((inputAnnotationCount == 0 && outputAnnotationCount == 0 ? 1 : 0) != 0, (String)"@Input or @Output annotations are not permitted on method parameters while using the @StreamListener value and a method-level output specification");
        }
        if (StringUtils.hasText((String)methodAnnotatedInboundName)) {
            Assert.isTrue((inputAnnotationCount == 0 ? 1 : 0) != 0, (String)"Cannot set both @StreamListener value and @Input annotation as method parameter");
            Assert.isTrue((outputAnnotationCount == 0 ? 1 : 0) != 0, (String)"Setting the @StreamListener value when using @Output annotation as method parameter is not permitted. Use @Input method parameter annotation to specify inbound value instead");
        } else {
            Assert.isTrue((inputAnnotationCount >= 1 ? 1 : 0) != 0, (String)"No input destination is configured. Use either the @StreamListener value or @Input");
        }
        if (StringUtils.hasText((String)methodAnnotatedOutboundName)) {
            Assert.isTrue((outputAnnotationCount == 0 ? 1 : 0) != 0, (String)"Cannot set both output (@Output/@SendTo) method annotation value and @Output annotation as a method parameter");
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            Assert.isTrue((!StringUtils.hasText((String)condition) ? 1 : 0) != 0, (String)"Cannot set a condition for methods that return a value");
        }
        if (isDeclarative) {
            Assert.isTrue((!StringUtils.hasText((String)condition) ? 1 : 0) != 0, (String)"Cannot set a condition when using @StreamListener in declarative mode");
            for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
                MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
                if (methodParameter.hasParameterAnnotation(Input.class)) {
                    String inboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
                    Assert.isTrue((boolean)StringUtils.hasText((String)inboundName), (String)"The @Input annotation must have the name of an input as value");
                }
                if (!methodParameter.hasParameterAnnotation(Output.class)) continue;
                String outboundName = (String)AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
                Assert.isTrue((boolean)StringUtils.hasText((String)outboundName), (String)"The @Output annotation must have the name of an input as value");
            }
            if (methodArgumentsLength > 1) {
                Assert.isTrue((inputAnnotationCount + outputAnnotationCount == methodArgumentsLength ? 1 : 0) != 0, (String)"A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
            }
        }
        if (!method.getReturnType().equals(Void.TYPE) && !StringUtils.hasText((String)methodAnnotatedOutboundName)) {
            if (outputAnnotationCount == 0) {
                throw new IllegalArgumentException("A method annotated with @StreamListener having a return type should also have an outbound target specified");
            }
            Assert.isTrue((outputAnnotationCount == 1 ? 1 : 0) != 0, (String)"A method annotated with @StreamListener having a return type should have only one outbound target specified");
        }
    }

    protected static void validateStreamListenerMessageHandler(Method method) {
        int methodArgumentsLength = method.getParameterTypes().length;
        if (methodArgumentsLength > 1) {
            int numAnnotatedMethodParameters = 0;
            int numPayloadAnnotations = 0;
            for (int parameterIndex = 0; parameterIndex < methodArgumentsLength; ++parameterIndex) {
                MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
                if (methodParameter.hasParameterAnnotations()) {
                    ++numAnnotatedMethodParameters;
                }
                if (!methodParameter.hasParameterAnnotation(Payload.class)) continue;
                ++numPayloadAnnotations;
            }
            if (numPayloadAnnotations > 0) {
                Assert.isTrue((methodArgumentsLength == numAnnotatedMethodParameters && numPayloadAnnotations <= 1 ? 1 : 0) != 0, (String)"Ambiguous method arguments for the StreamListener method");
            }
        }
    }

    protected static String getOutboundBindingTargetName(Method method) {
        SendTo sendTo = (SendTo)AnnotationUtils.findAnnotation((Method)method, SendTo.class);
        if (sendTo != null) {
            Assert.isTrue((!ObjectUtils.isEmpty((Object[])sendTo.value()) ? 1 : 0) != 0, (String)"At least one output must be specified");
            Assert.isTrue((sendTo.value().length == 1 ? 1 : 0) != 0, (String)"Multiple destinations cannot be specified");
            Assert.hasText((String)sendTo.value()[0], (String)"An empty destination cannot be specified");
            return sendTo.value()[0];
        }
        Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
        if (output != null) {
            Assert.isTrue((boolean)StringUtils.hasText((String)output.value()), (String)"At least one output must be specified");
            return output.value();
        }
        return null;
    }
}

