/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.BeanFactoryAwareFunctionRegistry;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.PartitionAwareFunctionWrapper;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public final class StreamBridge
implements SmartInitializingSingleton {
    private final Map<String, DirectWithAttributesChannel> outputChannelsOnly = new HashMap<String, DirectWithAttributesChannel>();
    private final FunctionCatalog functionCatalog;
    private final FunctionRegistry functionRegistry;
    private BindingServiceProperties bindingServiceProperties;
    private ConfigurableApplicationContext applicationContext;
    private boolean initialized;

    StreamBridge(FunctionCatalog functionCatalog, FunctionRegistry functionRegistry, BindingServiceProperties bindingServiceProperties, ConfigurableApplicationContext applicationContext) {
        this.functionCatalog = functionCatalog;
        this.functionRegistry = functionRegistry;
        this.applicationContext = applicationContext;
        this.bindingServiceProperties = bindingServiceProperties;
    }

    public boolean send(String bindingName, Object data) {
        return this.send(bindingName, data, MimeTypeUtils.APPLICATION_JSON);
    }

    public boolean send(String bindingName, Object data, MimeType outputContentType) {
        Assert.isTrue((boolean)this.outputChannelsOnly.containsKey(bindingName), (String)("Binding name '" + bindingName + "' does not exist."));
        BeanFactoryAwareFunctionRegistry.FunctionInvocationWrapper functionWrapper = (BeanFactoryAwareFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(bindingName, new String[]{outputContentType.toString()});
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindings().get(bindingName);
        ProducerProperties producerProperties = bindingProperties.getProducer();
        Object functionToInvoke = functionWrapper;
        if (producerProperties != null && producerProperties.isPartitioned()) {
            functionToInvoke = new PartitionAwareFunctionWrapper(functionWrapper, this.applicationContext, producerProperties);
        }
        Message resultMessage = (Message)functionToInvoke.apply(data);
        this.outputChannelsOnly.get(bindingName).send(resultMessage);
        return true;
    }

    public void afterSingletonsInstantiated() {
        if (this.initialized) {
            return;
        }
        Map channels = this.applicationContext.getBeansOfType(DirectWithAttributesChannel.class);
        for (Map.Entry channelEntry : channels.entrySet()) {
            if (!((DirectWithAttributesChannel)((Object)channelEntry.getValue())).getAttribute("type").equals("output")) continue;
            this.outputChannelsOnly.put((String)channelEntry.getKey(), (DirectWithAttributesChannel)((Object)channelEntry.getValue()));
            FunctionRegistration fr = new FunctionRegistration(v -> v, new String[]{(String)channelEntry.getKey()});
            fr.type(FunctionType.from(Object.class).to(Object.class));
            this.functionRegistry.register(fr);
            this.initialized = true;
        }
    }
}

