/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.amqp.RabbitHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfig;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.rabbit.config.RabbitConfiguration;
import org.springframework.cloud.stream.binder.rabbit.config.RabbitMessageChannelBinderConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={RabbitMessageChannelBinderConfiguration.class, RabbitHealthIndicatorConfiguration.class})
public abstract class RabbitBinderConfiguration {
    static void configureCachingConnectionFactory(CachingConnectionFactory connectionFactory, ConfigurableApplicationContext applicationContext, RabbitProperties rabbitProperties) throws Exception {
        if (StringUtils.hasText((String)rabbitProperties.getAddresses())) {
            connectionFactory.setAddresses(rabbitProperties.determineAddresses());
        }
        connectionFactory.setPublisherConfirmType(rabbitProperties.getPublisherConfirmType() == null ? CachingConnectionFactory.ConfirmType.NONE : rabbitProperties.getPublisherConfirmType());
        connectionFactory.setPublisherReturns(rabbitProperties.isPublisherReturns());
        if (rabbitProperties.getCache().getChannel().getSize() != null) {
            connectionFactory.setChannelCacheSize(rabbitProperties.getCache().getChannel().getSize().intValue());
        }
        if (rabbitProperties.getCache().getConnection().getMode() != null) {
            connectionFactory.setCacheMode(rabbitProperties.getCache().getConnection().getMode());
        }
        if (rabbitProperties.getCache().getConnection().getSize() != null) {
            connectionFactory.setConnectionCacheSize(rabbitProperties.getCache().getConnection().getSize().intValue());
        }
        if (rabbitProperties.getCache().getChannel().getCheckoutTimeout() != null) {
            connectionFactory.setChannelCheckoutTimeout(rabbitProperties.getCache().getChannel().getCheckoutTimeout().toMillis());
        }
        connectionFactory.setApplicationContext((ApplicationContext)applicationContext);
        applicationContext.addApplicationListener((ApplicationListener)connectionFactory);
        connectionFactory.afterPropertiesSet();
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
    public static class RabbitHealthIndicatorConfiguration {
        @Bean
        public HealthIndicator binderHealthIndicator(RabbitTemplate rabbitTemplate) {
            return new RabbitHealthIndicator(rabbitTemplate);
        }
    }

    @Configuration
    @Profile(value={"!cloud"})
    @Import(value={RabbitConfiguration.class})
    protected static class NoCloudProfile {
        protected NoCloudProfile() {
        }
    }

    @Configuration
    @Profile(value={"cloud"})
    protected static class CloudProfile {
        protected CloudProfile() {
        }

        @Configuration
        @ConditionalOnMissingClass(value={"org.springframework.cloud.Cloud"})
        @Import(value={RabbitConfiguration.class})
        protected static class NoCloudConnectors {
            protected NoCloudConnectors() {
            }
        }

        @Configuration
        @ConditionalOnClass(value={Cloud.class})
        protected static class CloudConnectors {
            protected CloudConnectors() {
            }

            @Bean
            @ConditionalOnMissingBean
            public Cloud cloud() {
                return new CloudFactory().getCloud();
            }

            @Configuration
            @ConditionalOnProperty(value={"spring.cloud.stream.override-cloud-connectors"})
            @Import(value={RabbitConfiguration.class})
            protected static class OverrideCloudConnectors {
                protected OverrideCloudConnectors() {
                }
            }

            @Configuration
            @ConditionalOnProperty(value={"spring.cloud.stream.override-cloud-connectors"}, havingValue="false", matchIfMissing=true)
            @EnableConfigurationProperties(value={RabbitProperties.class})
            protected static class UseCloudConnectors {
                protected UseCloudConnectors() {
                }

                @Bean
                @Primary
                ConnectionFactory rabbitConnectionFactory(Cloud cloud, ObjectProvider<RabbitConnectionFactoryConfig> connectorConfigObjectProvider, ConfigurableApplicationContext applicationContext, RabbitProperties rabbitProperties) throws Exception {
                    ConnectionFactory connectionFactory = (ConnectionFactory)cloud.getSingletonServiceConnector(ConnectionFactory.class, (ServiceConnectorConfig)connectorConfigObjectProvider.getIfUnique());
                    RabbitBinderConfiguration.configureCachingConnectionFactory((CachingConnectionFactory)connectionFactory, applicationContext, rabbitProperties);
                    return connectionFactory;
                }

                @Bean
                @ConditionalOnMissingBean(value={RabbitTemplate.class})
                RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
                    return new RabbitTemplate(connectionFactory);
                }
            }
        }
    }
}

