/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.metrics.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.MetricExportAutoConfiguration;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.metrics.export.MetricExporters;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.metrics.ApplicationMetricsExporter;
import org.springframework.cloud.stream.metrics.ApplicationMetricsProperties;
import org.springframework.cloud.stream.metrics.config.Emitter;
import org.springframework.cloud.stream.metrics.config.MetricJsonSerializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnClass(value={Binder.class})
@EnableBinding(value={Emitter.class})
@EnableConfigurationProperties(value={ApplicationMetricsProperties.class})
@AutoConfigureAfter(value={MetricExportAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.stream.bindings.applicationMetrics.destination"})
public class BinderMetricsAutoConfiguration {
    public static final String APPLICATION_METRICS_EXPORTER_TRIGGER_NAME = "application";
    public static Log log = LogFactory.getLog(BinderMetricsAutoConfiguration.class);

    @Bean
    public static BeanPostProcessor metricExportersBeanPostProcessor(final @Lazy MetricsEndpoint endpoint, final Emitter emitter, final ApplicationMetricsProperties properties) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
                if (bean instanceof MetricExporters) {
                    Map exporters = ((MetricExporters)bean).getExporters();
                    if (!exporters.containsKey(BinderMetricsAutoConfiguration.APPLICATION_METRICS_EXPORTER_TRIGGER_NAME)) {
                        exporters.put(BinderMetricsAutoConfiguration.APPLICATION_METRICS_EXPORTER_TRIGGER_NAME, new ApplicationMetricsExporter(endpoint, emitter.applicationMetrics(), properties));
                    } else {
                        log.warn((Object)("Could not register ApplicationMetricExporter: " + exporters.get(BinderMetricsAutoConfiguration.APPLICATION_METRICS_EXPORTER_TRIGGER_NAME) + " was already registered as " + BinderMetricsAutoConfiguration.APPLICATION_METRICS_EXPORTER_TRIGGER_NAME));
                    }
                }
                return bean;
            }
        };
    }

    @Bean
    public MetricJsonSerializer metricJsonSerializer() {
        return new MetricJsonSerializer();
    }
}

