/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.metrics.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class MetricJsonSerializer {
    private static final BlockingQueue<DateFormat> formatters = new LinkedBlockingQueue<DateFormat>();

    private static DateFormat defaultDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public static class Deserializer
    extends JsonDeserializer<Metric<?>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Metric<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String name = node.get("name").asText();
            Double value = node.get("value").asDouble();
            Date timestamp = null;
            DateFormat df = (DateFormat)formatters.poll();
            if (df == null) {
                df = MetricJsonSerializer.defaultDateFormat();
            }
            try {
                timestamp = df.parse(node.get("timestamp").asText());
            }
            catch (ParseException parseException) {
            }
            finally {
                formatters.offer(df);
            }
            Metric metric = new Metric(name, (Number)value, timestamp);
            return metric;
        }
    }

    public static class Serializer
    extends JsonSerializer<Metric<?>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(Metric<?> metric, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", metric.getName());
            json.writeNumberField("value", metric.getValue().doubleValue());
            DateFormat df = (DateFormat)formatters.poll();
            if (df == null) {
                df = MetricJsonSerializer.defaultDateFormat();
            }
            try {
                json.writeStringField("timestamp", df.format(metric.getTimestamp()));
                json.writeEndObject();
            }
            finally {
                formatters.offer(df);
            }
        }
    }
}

