/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.reactive.MessageChannelToFluxSenderParameterAdapter;
import org.springframework.cloud.stream.reactive.MessageChannelToInputFluxParameterAdapter;
import org.springframework.cloud.stream.reactive.PublisherToMessageChannelResultAdapter;
import org.springframework.cloud.stream.reactive.StreamEmitterAnnotationBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={BindingService.class})
public class ReactiveSupportAutoConfiguration {
    @Bean
    public static StreamEmitterAnnotationBeanPostProcessor streamEmitterAnnotationBeanPostProcessor() {
        return new StreamEmitterAnnotationBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageChannelToInputFluxParameterAdapter.class})
    public MessageChannelToInputFluxParameterAdapter messageChannelToInputFluxArgumentAdapter(CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new MessageChannelToInputFluxParameterAdapter(compositeMessageConverterFactory.getMessageConverterForAllRegistered());
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageChannelToFluxSenderParameterAdapter.class})
    public MessageChannelToFluxSenderParameterAdapter messageChannelToFluxSenderArgumentAdapter() {
        return new MessageChannelToFluxSenderParameterAdapter();
    }

    @Bean
    @ConditionalOnMissingBean(value={PublisherToMessageChannelResultAdapter.class})
    public PublisherToMessageChannelResultAdapter fluxToMessageChannelResultAdapter() {
        return new PublisherToMessageChannelResultAdapter();
    }
}

