/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.batch.core.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.task.batch.configuration.TaskBatchExecutionListenerBeanPostProcessor;
import org.springframework.cloud.task.batch.configuration.TaskBatchExecutionListenerFactoryBean;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnBean(value={Job.class})
@ConditionalOnProperty(name={"spring.cloud.task.batch.listener.enable"}, havingValue="true", matchIfMissing=true)
public class TaskBatchAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TaskBatchExecutionListenerBeanPostProcessor batchTaskExecutionListenerBeanPostProcessor() {
        return new TaskBatchExecutionListenerBeanPostProcessor();
    }

    @Configuration
    @ConditionalOnMissingBean(name={"taskBatchExecutionListener"})
    public static class TaskBatchExecutionListenerAutoconfiguration {
        @Autowired(required=false)
        private Collection<DataSource> dataSources;

        @Bean
        public TaskBatchExecutionListenerFactoryBean taskBatchExecutionListener(TaskExplorer taskExplorer) {
            if (!CollectionUtils.isEmpty(this.dataSources) && this.dataSources.size() == 1) {
                return new TaskBatchExecutionListenerFactoryBean(this.dataSources.iterator().next(), taskExplorer);
            }
            if (CollectionUtils.isEmpty(this.dataSources)) {
                return new TaskBatchExecutionListenerFactoryBean(null, taskExplorer);
            }
            throw new IllegalStateException("Expected one datasource and found " + this.dataSources.size());
        }
    }
}

