/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.partition;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.cloud.task.batch.partition.EnvironmentVariablesProvider;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class SimpleEnvironmentVariablesProvider
implements EnvironmentVariablesProvider {
    private Environment environment;
    private Map<String, String> environmentProperties = new HashMap<String, String>(0);
    private boolean includeCurrentEnvironment = true;

    public SimpleEnvironmentVariablesProvider(Environment environment) {
        this.environment = environment;
    }

    public void setEnvironmentProperties(Map<String, String> environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    public void setIncludeCurrentEnvironment(boolean includeCurrentEnvironment) {
        this.includeCurrentEnvironment = includeCurrentEnvironment;
    }

    @Override
    public Map<String, String> getEnvironmentVariables(ExecutionContext executionContext) {
        HashMap<String, String> environmentProperties = new HashMap<String, String>(this.environmentProperties.size());
        if (this.includeCurrentEnvironment) {
            environmentProperties.putAll(this.getCurrentEnvironmentProperties());
        }
        environmentProperties.putAll(this.environmentProperties);
        return environmentProperties;
    }

    private Map<String, String> getCurrentEnvironmentProperties() {
        HashMap<String, String> currentEnvironment = new HashMap<String, String>();
        HashSet<String> keys = new HashSet<String>();
        for (PropertySource propertySource : ((AbstractEnvironment)this.environment).getPropertySources()) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            keys.addAll(Arrays.asList(((MapPropertySource)propertySource).getPropertyNames()));
        }
        for (String key : keys) {
            currentEnvironment.put(key, this.environment.getProperty(key));
        }
        return currentEnvironment;
    }
}

