/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import javax.sql.DataSource;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.cloud.task.repository.support.SimpleTaskExplorer;
import org.springframework.cloud.task.repository.support.SimpleTaskRepository;
import org.springframework.cloud.task.repository.support.TaskExecutionDaoFactoryBean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultTaskConfigurer
implements TaskConfigurer {
    private TaskRepository taskRepository;
    private TaskExplorer taskExplorer;
    private PlatformTransactionManager transactionManager;
    private TaskExecutionDaoFactoryBean taskExecutionDaoFactoryBean;
    private DataSource dataSource;

    public DefaultTaskConfigurer(DataSource dataSource) {
        this.dataSource = dataSource;
        this.taskExecutionDaoFactoryBean = this.dataSource != null ? new TaskExecutionDaoFactoryBean(this.dataSource) : new TaskExecutionDaoFactoryBean();
        this.taskRepository = new SimpleTaskRepository(this.taskExecutionDaoFactoryBean);
        this.taskExplorer = new SimpleTaskExplorer(this.taskExecutionDaoFactoryBean);
    }

    @Override
    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    @Override
    public TaskExplorer getTaskExplorer() {
        return this.taskExplorer;
    }

    @Override
    public PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = this.isDataSourceAvailable() ? new DataSourceTransactionManager(this.dataSource) : new ResourcelessTransactionManager();
        }
        return this.transactionManager;
    }

    private boolean isDataSourceAvailable() {
        return this.dataSource != null;
    }
}

