/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ExitCodeEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskNameResolver;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class TaskLifecycleListener
implements ApplicationListener<ApplicationEvent>,
SmartLifecycle {
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired(required=false)
    private Collection<TaskExecutionListener> taskExecutionListeners;
    private static final Log logger = LogFactory.getLog(TaskLifecycleListener.class);
    private final TaskRepository taskRepository;
    private TaskExecution taskExecution;
    private boolean started = false;
    private TaskNameResolver taskNameResolver;
    private ApplicationArguments applicationArguments;
    private ApplicationFailedEvent applicationFailedEvent;
    private ExitCodeEvent exitCodeEvent;
    @Value(value="${spring.cloud.task.closecontext.enable:true}")
    private Boolean closeContext;

    public TaskLifecycleListener(TaskRepository taskRepository, TaskNameResolver taskNameResolver, ApplicationArguments applicationArguments) {
        Assert.notNull((Object)taskRepository, (String)"A taskRepository is required");
        Assert.notNull((Object)taskNameResolver, (String)"A taskNameResolver is required");
        this.taskRepository = taskRepository;
        this.taskNameResolver = taskNameResolver;
        this.applicationArguments = applicationArguments;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ApplicationFailedEvent) {
            this.applicationFailedEvent = (ApplicationFailedEvent)applicationEvent;
            this.doTaskEnd();
        } else if (applicationEvent instanceof ExitCodeEvent) {
            this.exitCodeEvent = (ExitCodeEvent)applicationEvent;
            this.doTaskEnd();
        } else if (applicationEvent instanceof ApplicationReadyEvent) {
            this.doTaskEnd();
        }
    }

    private String stackTraceToString(Throwable exception) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        exception.printStackTrace(printWriter);
        return writer.toString();
    }

    private void doTaskEnd() {
        if (this.started) {
            this.taskExecution.setEndTime(new Date());
            if (this.exitCodeEvent != null) {
                this.taskExecution.setExitCode(this.exitCodeEvent.getExitCode());
            } else if (this.applicationFailedEvent != null) {
                this.taskExecution.setExitCode(1);
            } else {
                this.taskExecution.setExitCode(0);
            }
            if (this.applicationFailedEvent != null) {
                this.taskExecution.setExitMessage(this.stackTraceToString(this.applicationFailedEvent.getException()));
            }
            if (this.taskExecution.getExitCode() != 0) {
                this.taskExecution.setExitMessage(this.invokeOnTaskError(this.taskExecution, this.applicationFailedEvent.getException()).getExitMessage());
            }
            this.taskExecution.setExitMessage(this.invokeOnTaskEnd(this.taskExecution).getExitMessage());
            this.taskRepository.completeTaskExecution(this.taskExecution.getExecutionId(), this.taskExecution.getExitCode(), this.taskExecution.getEndTime(), this.taskExecution.getExitMessage());
            if (this.closeContext.booleanValue() && this.context.isActive()) {
                this.context.close();
            }
        } else {
            logger.error((Object)"An event to end a task has been received for a task that has not yet started.");
        }
    }

    private void doTaskStart() {
        if (!this.started) {
            ArrayList<String> args = new ArrayList(0);
            if (this.applicationArguments != null) {
                args = Arrays.asList(this.applicationArguments.getSourceArgs());
            }
            this.taskExecution = this.taskRepository.createTaskExecution(this.taskNameResolver.getTaskName(), new Date(), args);
        } else {
            logger.error((Object)"Multiple start events have been received.  The first one was recorded.");
        }
        this.taskExecution.setExitMessage(this.invokeOnTaskStartup(this.taskExecution).getExitMessage());
    }

    private TaskExecution invokeOnTaskStartup(TaskExecution taskExecution) {
        TaskExecution listenerTaskExecution = this.getTaskExecutionCopy(taskExecution);
        if (this.taskExecutionListeners != null) {
            for (TaskExecutionListener taskExecutionListener : this.taskExecutionListeners) {
                taskExecutionListener.onTaskStartup(listenerTaskExecution);
            }
        }
        return listenerTaskExecution;
    }

    private TaskExecution invokeOnTaskEnd(TaskExecution taskExecution) {
        TaskExecution listenerTaskExecution = this.getTaskExecutionCopy(taskExecution);
        if (this.taskExecutionListeners != null) {
            for (TaskExecutionListener taskExecutionListener : this.taskExecutionListeners) {
                taskExecutionListener.onTaskEnd(listenerTaskExecution);
            }
        }
        return listenerTaskExecution;
    }

    private TaskExecution invokeOnTaskError(TaskExecution taskExecution, Throwable throwable) {
        TaskExecution listenerTaskExecution = this.getTaskExecutionCopy(taskExecution);
        if (this.taskExecutionListeners != null) {
            for (TaskExecutionListener taskExecutionListener : this.taskExecutionListeners) {
                taskExecutionListener.onTaskFailed(listenerTaskExecution, throwable);
            }
        }
        return listenerTaskExecution;
    }

    private TaskExecution getTaskExecutionCopy(TaskExecution taskExecution) {
        Date startTime = new Date(taskExecution.getStartTime().getTime());
        Date endTime = taskExecution.getEndTime() == null ? null : new Date(taskExecution.getEndTime().getTime());
        return new TaskExecution(taskExecution.getExecutionId(), taskExecution.getExitCode(), taskExecution.getTaskName(), startTime, endTime, taskExecution.getExitMessage(), Collections.unmodifiableList(taskExecution.getArguments()));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        Assert.notNull((Object)callback, (String)"A callback is required");
        callback.run();
    }

    public void start() {
        this.doTaskStart();
        this.started = true;
    }

    public void stop() {
    }

    public boolean isRunning() {
        return this.started;
    }

    public int getPhase() {
        return 0;
    }
}

