/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.support;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.util.Assert;

public class SimpleTaskRepository
implements TaskRepository {
    public static final int MAX_EXIT_MESSAGE_SIZE = 2500;
    public static final int MAX_TASK_NAME_SIZE = 100;
    private static final Log logger = LogFactory.getLog(SimpleTaskRepository.class);
    private TaskExecutionDao taskExecutionDao;
    private FactoryBean<TaskExecutionDao> taskExecutionDaoFactoryBean;
    private boolean initialized = false;

    public SimpleTaskRepository(FactoryBean<TaskExecutionDao> taskExecutionDaoFactoryBean) {
        Assert.notNull(taskExecutionDaoFactoryBean, (String)"A FactoryBean that provides a TaskExecutionDao is required");
        this.taskExecutionDaoFactoryBean = taskExecutionDaoFactoryBean;
    }

    @Override
    public TaskExecution completeTaskExecution(long executionId, Integer exitCode, Date endTime, String exitMessage) {
        this.initialize();
        this.validateExitInformation(executionId, exitCode, endTime);
        exitMessage = this.trimExitMessage(exitMessage);
        this.taskExecutionDao.completeTaskExecution(executionId, exitCode, endTime, exitMessage);
        logger.debug((Object)("Updating: TaskExecution with executionId=" + executionId + " with the following {" + "exitCode=" + exitCode + ", endTime=" + endTime + ", exitMessage='" + exitMessage + '\'' + '}'));
        return this.taskExecutionDao.getTaskExecution(executionId);
    }

    @Override
    public TaskExecution createTaskExecution(String taskName, Date startTime, List<String> arguments) {
        this.initialize();
        this.validateCreateInformation(startTime, taskName);
        TaskExecution taskExecution = this.taskExecutionDao.createTaskExecution(taskName, startTime, arguments);
        logger.debug((Object)("Creating: " + taskExecution.toString()));
        return taskExecution;
    }

    public TaskExecutionDao getTaskExecutionDao() {
        this.initialize();
        return this.taskExecutionDao;
    }

    private void initialize() {
        if (!this.initialized) {
            try {
                this.taskExecutionDao = (TaskExecutionDao)this.taskExecutionDaoFactoryBean.getObject();
                this.initialized = true;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create the TaskExecutionDao", e);
            }
        }
    }

    private void validateCreateInformation(Date startTime, String taskName) {
        Assert.notNull((Object)startTime, (String)"TaskExecution start time cannot be null.");
        if (taskName != null && taskName.length() > 100) {
            throw new IllegalArgumentException("TaskName length exceeds 100 characters");
        }
    }

    private void validateExitInformation(long executionId, Integer exitCode, Date endTime) {
        Assert.notNull((Object)exitCode, (String)"exitCode should not be null");
        Assert.isTrue((exitCode >= 0 ? 1 : 0) != 0, (String)"exit code must be greater than or equal to zero");
        Assert.notNull((Object)endTime, (String)"TaskExecution endTime cannot be null.");
    }

    private String trimExitMessage(String exitMessage) {
        String result = exitMessage;
        if (exitMessage != null && exitMessage.length() > 2500) {
            result = exitMessage.substring(0, 2499);
        }
        return result;
    }
}

