/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.support;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.task.repository.support.DatabaseType;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.support.MetaDataAccessException;

public final class TaskRepositoryInitializer
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(TaskRepositoryInitializer.class);
    private static final String DEFAULT_SCHEMA_LOCATION = "classpath:org/springframework/cloud/task/schema-@@platform@@.sql";
    private static String schema = "classpath:org/springframework/cloud/task/schema-@@platform@@.sql";
    private DataSource dataSource;
    private ResourceLoader resourceLoader;
    @Value(value="${spring.cloud.task.initialize.enable:true}")
    private boolean taskInitializationEnable;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Autowired(required=false)
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private String getDatabaseType(DataSource dataSource) {
        try {
            return DatabaseType.fromMetaData(dataSource).toString().toLowerCase();
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException("Unable to detect database type", ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource != null && this.taskInitializationEnable) {
            String platform = this.getDatabaseType(this.dataSource);
            if ("hsql".equals(platform)) {
                platform = "hsqldb";
            }
            if ("postgres".equals(platform)) {
                platform = "postgresql";
            }
            if ("oracle".equals(platform)) {
                platform = "oracle10g";
            }
            if ("mysql".equals(platform)) {
                platform = "mysql";
            }
            if ("sqlserver".equals(platform)) {
                platform = "sqlserver";
            }
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            String schemaLocation = schema;
            schemaLocation = schemaLocation.replace("@@platform@@", platform);
            populator.addScript(this.resourceLoader.getResource(schemaLocation));
            populator.setContinueOnError(true);
            logger.debug((Object)String.format("Initializing task schema for %s database", platform));
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
        }
    }
}

