/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.util.Assert;

public class TaskExecution {
    private long executionId;
    private Integer exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private List<String> arguments;

    public TaskExecution() {
        this.arguments = new ArrayList<String>();
    }

    public TaskExecution(long executionId, Integer exitCode, String taskName, Date startTime, Date endTime, String exitMessage, List<String> arguments) {
        Assert.notNull(arguments, (String)"arguments must not be null");
        Assert.notNull((Object)startTime, (String)"startTime must not be null");
        this.executionId = executionId;
        this.exitCode = exitCode;
        this.taskName = taskName;
        this.exitMessage = exitMessage;
        this.arguments = new ArrayList<String>(arguments);
        this.startTime = (Date)startTime.clone();
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public Integer getExitCode() {
        return this.exitCode == null ? 0 : this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime != null ? (Date)startTime.clone() : null;
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public void setExitMessage(String exitMessage) {
        this.exitMessage = exitMessage;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = new ArrayList<String>(arguments);
    }

    public String toString() {
        return "TaskExecution{executionId=" + this.executionId + ", exitCode=" + this.exitCode + ", taskName='" + this.taskName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", exitMessage='" + this.exitMessage + '\'' + ", arguments=" + this.arguments + '}';
    }
}

