/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.springframework.batch.item.database.Order;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.cloud.task.repository.database.PagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcTaskExecutionDao
implements TaskExecutionDao {
    public static final String SELECT_CLAUSE = "TASK_EXECUTION_ID, START_TIME, END_TIME, TASK_NAME, EXIT_CODE, EXIT_MESSAGE, LAST_UPDATED ";
    public static final String FROM_CLAUSE = "%PREFIX%EXECUTION";
    public static final String RUNNING_TASK_WHERE_CLAUSE = "where TASK_NAME = ? AND END_TIME IS NULL ";
    public static final String TASK_NAME_WHERE_CLAUSE = "where TASK_NAME = ? ";
    private static final String SAVE_TASK_EXECUTION = "INSERT into %PREFIX%EXECUTION(TASK_EXECUTION_ID, START_TIME, TASK_NAME, LAST_UPDATED)values (?, ?, ?, ?)";
    private static final String CREATE_TASK_ARGUMENT = "INSERT into %PREFIX%EXECUTION_PARAMS(TASK_EXECUTION_ID, TASK_PARAM ) values (?, ?)";
    private static final String CHECK_TASK_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%EXECUTION WHERE TASK_EXECUTION_ID = ?";
    private static final String UPDATE_TASK_EXECUTION = "UPDATE %PREFIX%EXECUTION set END_TIME = ?, EXIT_CODE = ?, EXIT_MESSAGE = ?, LAST_UPDATED = ? where TASK_EXECUTION_ID = ?";
    private static final String GET_EXECUTION_BY_ID = "SELECT TASK_EXECUTION_ID, START_TIME, END_TIME, TASK_NAME, EXIT_CODE, EXIT_MESSAGE, LAST_UPDATED from %PREFIX%EXECUTION where TASK_EXECUTION_ID = ?";
    private static final String FIND_ARGUMENT_FROM_ID = "SELECT TASK_EXECUTION_ID, TASK_PARAM from %PREFIX%EXECUTION_PARAMS where TASK_EXECUTION_ID = ?";
    private static final String TASK_EXECUTION_COUNT = "SELECT COUNT(*) FROM %PREFIX%EXECUTION ";
    private static final String TASK_EXECUTION_COUNT_BY_NAME = "SELECT COUNT(*) FROM %PREFIX%EXECUTION where TASK_NAME = ?";
    private static final String RUNNING_TASK_EXECUTION_COUNT_BY_NAME = "SELECT COUNT(*) FROM %PREFIX%EXECUTION where TASK_NAME = ? AND END_TIME IS NULL ";
    private static final String FIND_TASK_NAMES = "SELECT distinct TASK_NAME from %PREFIX%EXECUTION order by TASK_NAME";
    private static final String FIND_TASK_EXECUTION_BY_JOB_EXECUTION_ID = "SELECT TASK_EXECUTION_ID FROM %PREFIX%TASK_BATCH WHERE JOB_EXECUTION_ID = ?";
    private static final String FIND_JOB_EXECUTION_BY_TASK_EXECUTION_ID = "SELECT JOB_EXECUTION_ID FROM %PREFIX%TASK_BATCH WHERE TASK_EXECUTION_ID = ?";
    public static final String DEFAULT_TABLE_PREFIX = "TASK_";
    private String tablePrefix = "TASK_";
    private JdbcOperations jdbcTemplate;
    private DataSource dataSource;
    private Map<String, Order> orderMap;
    private DataFieldMaxValueIncrementer taskIncrementer;

    public JdbcTaskExecutionDao(DataSource dataSource) {
        Assert.notNull((Object)dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dataSource = dataSource;
        this.orderMap = new TreeMap<String, Order>();
        this.orderMap.put("START_TIME", Order.DESCENDING);
        this.orderMap.put("TASK_EXECUTION_ID", Order.DESCENDING);
    }

    @Override
    public TaskExecution createTaskExecution(String taskName, Date startTime, List<String> arguments) {
        long taskExecutionId = this.getNextExecutionId();
        TaskExecution taskExecution = new TaskExecution(taskExecutionId, null, taskName, startTime, null, null, arguments);
        Object[] queryParameters = new Object[]{taskExecutionId, startTime, taskName, new Date()};
        this.jdbcTemplate.update(this.getQuery(SAVE_TASK_EXECUTION), queryParameters, new int[]{-5, 93, 12, 93});
        this.insertTaskArguments(taskExecutionId, arguments);
        return taskExecution;
    }

    @Override
    public void completeTaskExecution(long taskExecutionId, Integer exitCode, Date endTime, String exitMessage) {
        if ((Integer)this.jdbcTemplate.queryForObject(this.getQuery(CHECK_TASK_EXECUTION_EXISTS), Integer.class, new Object[]{taskExecutionId}) != 1) {
            throw new IllegalStateException("Invalid TaskExecution, ID " + taskExecutionId + " not found.");
        }
        Object[] parameters = new Object[]{endTime, exitCode, exitMessage, new Date(), taskExecutionId};
        this.jdbcTemplate.update(this.getQuery(UPDATE_TASK_EXECUTION), parameters, new int[]{93, 4, 12, 93, -5});
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public TaskExecution getTaskExecution(long executionId) {
        try {
            TaskExecution taskExecution = (TaskExecution)this.jdbcTemplate.queryForObject(this.getQuery(GET_EXECUTION_BY_ID), (RowMapper)new TaskExecutionRowMapper(), new Object[]{executionId});
            taskExecution.setArguments(this.getTaskArguments(executionId));
            return taskExecution;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public long getTaskExecutionCountByTaskName(String taskName) {
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(TASK_EXECUTION_COUNT_BY_NAME), new Object[]{taskName}, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public long getRunningTaskExecutionCountByTaskName(String taskName) {
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(RUNNING_TASK_EXECUTION_COUNT_BY_NAME), new Object[]{taskName}, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public long getTaskExecutionCount() {
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(TASK_EXECUTION_COUNT), new Object[0], Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public Page<TaskExecution> findRunningTaskExecutions(String taskName, Pageable pageable) {
        return this.queryForPageableResults(pageable, SELECT_CLAUSE, FROM_CLAUSE, RUNNING_TASK_WHERE_CLAUSE, new Object[]{taskName}, this.getRunningTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public Page<TaskExecution> findTaskExecutionsByName(String taskName, Pageable pageable) {
        return this.queryForPageableResults(pageable, SELECT_CLAUSE, FROM_CLAUSE, TASK_NAME_WHERE_CLAUSE, new Object[]{taskName}, this.getTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public List<String> getTaskNames() {
        return this.jdbcTemplate.queryForList(this.getQuery(FIND_TASK_NAMES), String.class);
    }

    @Override
    public Page<TaskExecution> findAll(Pageable pageable) {
        return this.queryForPageableResults(pageable, SELECT_CLAUSE, FROM_CLAUSE, null, new Object[0], this.getTaskExecutionCount());
    }

    public void setTaskIncrementer(DataFieldMaxValueIncrementer taskIncrementer) {
        this.taskIncrementer = taskIncrementer;
    }

    @Override
    public long getNextExecutionId() {
        return this.taskIncrementer.nextLongValue();
    }

    @Override
    public Long getTaskExecutionIdByJobExecutionId(long jobExecutionId) {
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(FIND_TASK_EXECUTION_BY_JOB_EXECUTION_ID), new Object[]{jobExecutionId}, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Set<Long> getJobExecutionIdsByTaskExecutionId(long taskExecutionId) {
        try {
            return (Set)this.jdbcTemplate.query(this.getQuery(FIND_JOB_EXECUTION_BY_TASK_EXECUTION_ID), new Object[]{taskExecutionId}, (ResultSetExtractor)new ResultSetExtractor<Set<Long>>(){

                public Set<Long> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                    TreeSet<Long> jobExecutionIds = new TreeSet<Long>();
                    while (resultSet.next()) {
                        jobExecutionIds.add(resultSet.getLong("JOB_EXECUTION_ID"));
                    }
                    return jobExecutionIds;
                }
            });
        }
        catch (DataAccessException e) {
            return Collections.emptySet();
        }
    }

    private Page<TaskExecution> queryForPageableResults(Pageable pageable, String selectClause, String fromClause, String whereClause, Object[] queryParam, long totalCount) {
        PagingQueryProvider pagingQueryProvider;
        SqlPagingQueryProviderFactoryBean factoryBean = new SqlPagingQueryProviderFactoryBean();
        factoryBean.setSelectClause(selectClause);
        factoryBean.setFromClause(fromClause);
        if (StringUtils.hasText((String)whereClause)) {
            factoryBean.setWhereClause(whereClause);
        }
        factoryBean.setSortKeys(this.orderMap);
        factoryBean.setDataSource(this.dataSource);
        try {
            pagingQueryProvider = factoryBean.getObject();
            pagingQueryProvider.init(this.dataSource);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        String query = pagingQueryProvider.getPageQuery(pageable);
        List resultList = this.jdbcTemplate.query(this.getQuery(query), queryParam, (RowMapper)new TaskExecutionRowMapper());
        return new PageImpl(resultList, pageable, totalCount);
    }

    private String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%PREFIX%", (String)this.tablePrefix);
    }

    private void insertTaskArguments(long executionId, List<String> taskArguments) {
        for (String args : taskArguments) {
            this.insertArgument(executionId, args);
        }
    }

    private void insertArgument(long executionId, String param) {
        int[] argTypes = new int[]{-5, 12};
        Object[] args = new Object[]{executionId, param};
        this.jdbcTemplate.update(this.getQuery(CREATE_TASK_ARGUMENT), args, argTypes);
    }

    private List<String> getTaskArguments(long executionId) {
        final ArrayList<String> params = new ArrayList<String>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                params.add(rs.getString(2));
            }
        };
        this.jdbcTemplate.query(this.getQuery(FIND_ARGUMENT_FROM_ID), new Object[]{executionId}, handler);
        return params;
    }

    private final class TaskExecutionRowMapper
    implements RowMapper<TaskExecution> {
        public TaskExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            long id = rs.getLong("TASK_EXECUTION_ID");
            return new TaskExecution(id, this.getNullableExitCode(rs), rs.getString("TASK_NAME"), rs.getTimestamp("START_TIME"), rs.getTimestamp("END_TIME"), rs.getString("EXIT_MESSAGE"), JdbcTaskExecutionDao.this.getTaskArguments(id));
        }

        private Integer getNullableExitCode(ResultSet rs) throws SQLException {
            int exitCode = rs.getInt("EXIT_CODE");
            return !rs.wasNull() ? Integer.valueOf(exitCode) : null;
        }
    }
}

