/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class MapTaskExecutionDao
implements TaskExecutionDao {
    private ConcurrentMap<Long, TaskExecution> taskExecutions;
    private ConcurrentMap<Long, Set<Long>> batchJobAssociations;
    private final AtomicLong currentId = new AtomicLong(0L);

    public MapTaskExecutionDao() {
        this.taskExecutions = new ConcurrentHashMap<Long, TaskExecution>();
        this.batchJobAssociations = new ConcurrentHashMap<Long, Set<Long>>();
    }

    @Override
    public TaskExecution createTaskExecution(String taskName, Date startTime, List<String> arguments) {
        long taskExecutionId = this.getNextExecutionId();
        TaskExecution taskExecution = new TaskExecution(taskExecutionId, null, taskName, startTime, null, null, arguments);
        this.taskExecutions.put(taskExecutionId, taskExecution);
        return taskExecution;
    }

    @Override
    public void completeTaskExecution(long executionId, Integer exitCode, Date endTime, String exitMessage) {
        TaskExecution taskExecution = (TaskExecution)this.taskExecutions.get(executionId);
        taskExecution.setEndTime(endTime);
        taskExecution.setExitCode(exitCode);
        taskExecution.setExitMessage(exitMessage);
    }

    @Override
    public TaskExecution getTaskExecution(long executionId) {
        return (TaskExecution)this.taskExecutions.get(executionId);
    }

    @Override
    public long getTaskExecutionCountByTaskName(String taskName) {
        int count = 0;
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long getRunningTaskExecutionCountByTaskName(String taskName) {
        int count = 0;
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName) || ((TaskExecution)entry.getValue()).getEndTime() != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long getTaskExecutionCount() {
        return this.taskExecutions.size();
    }

    @Override
    public Page<TaskExecution> findRunningTaskExecutions(String taskName, Pageable pageable) {
        TreeSet<TaskExecution> result = this.getTaskExecutionTreeSet();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName) || ((TaskExecution)entry.getValue()).getEndTime() != null) continue;
            result.add((TaskExecution)entry.getValue());
        }
        return this.getPageFromList(new ArrayList<TaskExecution>(result), pageable, this.getRunningTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public Page<TaskExecution> findTaskExecutionsByName(String taskName, Pageable pageable) {
        TreeSet<TaskExecution> filteredSet = this.getTaskExecutionTreeSet();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName)) continue;
            filteredSet.add((TaskExecution)entry.getValue());
        }
        return this.getPageFromList(new ArrayList<TaskExecution>(filteredSet), pageable, this.getTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public List<String> getTaskNames() {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            result.add(((TaskExecution)entry.getValue()).getTaskName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public Page<TaskExecution> findAll(Pageable pageable) {
        TreeSet<TaskExecution> sortedSet = this.getTaskExecutionTreeSet();
        sortedSet.addAll(this.taskExecutions.values());
        ArrayList<TaskExecution> result = new ArrayList<TaskExecution>(sortedSet.descendingSet());
        return this.getPageFromList(result, pageable, this.getTaskExecutionCount());
    }

    public Map<Long, TaskExecution> getTaskExecutions() {
        return Collections.unmodifiableMap(this.taskExecutions);
    }

    @Override
    public long getNextExecutionId() {
        return this.currentId.getAndIncrement();
    }

    @Override
    public Long getTaskExecutionIdByJobExecutionId(long jobExecutionId) {
        Long taskId = null;
        block0: for (Map.Entry association : this.batchJobAssociations.entrySet()) {
            for (Long curJobExecutionId : (Set)association.getValue()) {
                if (!curJobExecutionId.equals(jobExecutionId)) continue;
                taskId = (Long)association.getKey();
                break block0;
            }
        }
        return taskId;
    }

    @Override
    public Set<Long> getJobExecutionIdsByTaskExecutionId(long taskExecutionId) {
        if (this.batchJobAssociations.containsKey(taskExecutionId)) {
            return Collections.unmodifiableSet((Set)this.batchJobAssociations.get(taskExecutionId));
        }
        return new TreeSet<Long>();
    }

    public ConcurrentMap<Long, Set<Long>> getBatchJobAssociations() {
        return this.batchJobAssociations;
    }

    private TreeSet<TaskExecution> getTaskExecutionTreeSet() {
        return new TreeSet<TaskExecution>(new Comparator<TaskExecution>(){

            @Override
            public int compare(TaskExecution e1, TaskExecution e2) {
                int result = e1.getStartTime().compareTo(e2.getStartTime());
                if (result == 0) {
                    result = Long.valueOf(e1.getExecutionId()).compareTo(e2.getExecutionId());
                }
                return result;
            }
        });
    }

    private Page getPageFromList(List<TaskExecution> executionList, Pageable pageable, long maxSize) {
        int toIndex = pageable.getOffset() + pageable.getPageSize() > executionList.size() ? executionList.size() : pageable.getOffset() + pageable.getPageSize();
        return new PageImpl(executionList.subList(pageable.getOffset(), toIndex), pageable, maxSize);
    }
}

