/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.database.support;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.database.Order;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.repository.database.PagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.Db2PagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.H2PagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.HsqlPagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.MySqlPagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.OraclePagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.PostgresPagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.SqlServerPagingQueryProvider;
import org.springframework.cloud.task.repository.support.DatabaseType;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SqlPagingQueryProviderFactoryBean
implements FactoryBean<PagingQueryProvider> {
    private DataSource dataSource;
    private String databaseType;
    private String fromClause;
    private String whereClause;
    private String selectClause;
    private Map<String, Order> sortKeys;
    private Map<DatabaseType, AbstractSqlPagingQueryProvider> providers = new HashMap<DatabaseType, AbstractSqlPagingQueryProvider>();

    public SqlPagingQueryProviderFactoryBean() {
        this.providers.put(DatabaseType.HSQL, new HsqlPagingQueryProvider());
        this.providers.put(DatabaseType.H2, new H2PagingQueryProvider());
        this.providers.put(DatabaseType.MYSQL, new MySqlPagingQueryProvider());
        this.providers.put(DatabaseType.POSTGRES, new PostgresPagingQueryProvider());
        this.providers.put(DatabaseType.ORACLE, new OraclePagingQueryProvider());
        this.providers.put(DatabaseType.SQLSERVER, new SqlServerPagingQueryProvider());
        this.providers.put(DatabaseType.DB2, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2VSE, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2ZOS, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2AS400, new Db2PagingQueryProvider());
    }

    public void setDatabaseType(String databaseType) {
        Assert.hasText((String)databaseType, (String)"databaseType must not be empty nor null");
        this.databaseType = databaseType;
    }

    public void setDataSource(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null");
        this.dataSource = dataSource;
    }

    public void setFromClause(String fromClause) {
        Assert.hasText((String)fromClause, (String)"fromClause must not be empty nor null");
        this.fromClause = fromClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public void setSelectClause(String selectClause) {
        Assert.hasText((String)selectClause, (String)"selectClause must not be empty nor null");
        this.selectClause = selectClause;
    }

    public void setSortKeys(Map<String, Order> sortKeys) {
        this.sortKeys = sortKeys;
    }

    public PagingQueryProvider getObject() throws Exception {
        DatabaseType type;
        try {
            type = this.databaseType != null ? DatabaseType.valueOf(this.databaseType.toUpperCase()) : DatabaseType.fromMetaData(this.dataSource);
        }
        catch (MetaDataAccessException e) {
            throw new IllegalArgumentException("Could not inspect meta data for database type.  You have to supply it explicitly.", e);
        }
        AbstractSqlPagingQueryProvider provider = this.providers.get((Object)type);
        Assert.state((provider != null ? 1 : 0) != 0, (String)("Should not happen: missing PagingQueryProvider for DatabaseType=" + (Object)((Object)type)));
        provider.setFromClause(this.fromClause);
        provider.setWhereClause(this.whereClause);
        provider.setSortKeys(this.sortKeys);
        if (StringUtils.hasText((String)this.selectClause)) {
            provider.setSelectClause(this.selectClause);
        }
        provider.init(this.dataSource);
        return provider;
    }

    public Class<PagingQueryProvider> getObjectType() {
        return PagingQueryProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

