/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.database.support;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.batch.item.database.Order;
import org.springframework.cloud.task.repository.database.PagingQueryProvider;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractSqlPagingQueryProvider
implements PagingQueryProvider {
    private String selectClause;
    private String fromClause;
    private String whereClause;
    private Map<String, Order> sortKeys = new LinkedHashMap<String, Order>();
    private int parameterCount;
    private boolean usingNamedParameters;

    public void setSelectClause(String selectClause) {
        this.selectClause = this.removeKeyWord("select", selectClause);
    }

    protected String getSelectClause() {
        return this.selectClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = this.removeKeyWord("from", fromClause);
    }

    protected String getFromClause() {
        return this.fromClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = StringUtils.hasText((String)whereClause) ? this.removeKeyWord("where", whereClause) : null;
    }

    protected String getWhereClause() {
        return this.whereClause;
    }

    public void setSortKeys(Map<String, Order> sortKeys) {
        this.sortKeys = sortKeys;
    }

    @Override
    public Map<String, Order> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public boolean isUsingNamedParameters() {
        return this.usingNamedParameters;
    }

    @Override
    public void init(DataSource dataSource) throws Exception {
        Assert.notNull((Object)dataSource);
        Assert.hasLength((String)this.selectClause, (String)"selectClause must be specified");
        Assert.hasLength((String)this.fromClause, (String)"fromClause must be specified");
        Assert.notEmpty(this.sortKeys, (String)"sortKey must be specified");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.selectClause);
        sql.append(" FROM ").append(this.fromClause);
        if (this.whereClause != null) {
            sql.append(" WHERE ").append(this.whereClause);
        }
        ArrayList namedParameters = new ArrayList();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders((String)sql.toString(), namedParameters);
        if (namedParameters.size() > 0) {
            if (this.parameterCount != namedParameters.size()) {
                throw new InvalidDataAccessApiUsageException("You can't use both named parameters and classic \"?\" placeholders: " + sql);
            }
            this.usingNamedParameters = true;
        }
    }

    private String removeKeyWord(String keyWord, String clause) {
        String temp = clause.trim();
        String keyWordString = keyWord + " ";
        if (temp.toLowerCase().startsWith(keyWordString) && temp.length() > keyWordString.length()) {
            return temp.substring(keyWordString.length());
        }
        return temp;
    }
}

