/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.springframework.cloud.task.repository.TaskExecution;

public class TaskMetrics {
    public static final String SPRING_CLOUD_TASK_METER = "spring.cloud.task";
    public static final String SPRING_CLOUD_TASK_ACTIVE_METER = "spring.cloud.task.active";
    public static final String STATUS_SUCCESS = "success";
    public static final String STATUS_FAILURE = "failure";
    public static final String TASK_NAME_TAG = "task.name";
    public static final String TASK_EXECUTION_ID_TAG = "task.execution.id";
    public static final String TASK_PARENT_EXECUTION_ID_TAG = "task.parent.execution.id";
    public static final String TASK_EXTERNAL_EXECUTION_ID_TAG = "task.external.execution.id";
    public static final String TASK_EXIT_CODE_TAG = "task.exit.code";
    public static final String TASK_STATUS_TAG = "task.status";
    public static final String TASK_EXCEPTION_TAG = "task.exception";
    private Timer.Sample taskSample;
    private LongTaskTimer.Sample longTaskSample;
    private Throwable exception;

    public void onTaskStartup(TaskExecution taskExecution) {
        LongTaskTimer longTaskTimer = LongTaskTimer.builder((String)SPRING_CLOUD_TASK_ACTIVE_METER).description("Long task duration").tags((Iterable)this.commonTags(taskExecution)).register((MeterRegistry)Metrics.globalRegistry);
        this.longTaskSample = longTaskTimer.start();
        this.taskSample = Timer.start((MeterRegistry)Metrics.globalRegistry);
    }

    public void onTaskFailed(Throwable throwable) {
        this.exception = throwable;
    }

    public void onTaskEnd(TaskExecution taskExecution) {
        if (this.taskSample != null) {
            this.taskSample.stop(Timer.builder((String)SPRING_CLOUD_TASK_METER).description("Task duration").tags((Iterable)this.commonTags(taskExecution)).tag(TASK_EXIT_CODE_TAG, "" + taskExecution.getExitCode()).tag(TASK_EXCEPTION_TAG, this.exception == null ? "none" : this.exception.getClass().getSimpleName()).tag(TASK_STATUS_TAG, this.exception == null ? STATUS_SUCCESS : STATUS_FAILURE).register((MeterRegistry)Metrics.globalRegistry));
            this.taskSample = null;
        }
        if (this.longTaskSample != null) {
            this.longTaskSample.stop();
            this.longTaskSample = null;
        }
    }

    private Tags commonTags(TaskExecution taskExecution) {
        return Tags.of((String)TASK_NAME_TAG, (String)taskExecution.getTaskName()).and(TASK_EXECUTION_ID_TAG, "" + taskExecution.getExecutionId()).and(TASK_PARENT_EXECUTION_ID_TAG, "" + taskExecution.getParentExecutionId()).and(TASK_EXTERNAL_EXECUTION_ID_TAG, taskExecution.getExternalExecutionId() == null ? "unknown" : "" + taskExecution.getExternalExecutionId());
    }
}

