/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.springframework.batch.item.database.Order;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.cloud.task.repository.database.PagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JdbcTaskExecutionDao
implements TaskExecutionDao {
    public static final String SELECT_CLAUSE = "TASK_EXECUTION_ID, START_TIME, END_TIME, TASK_NAME, EXIT_CODE, EXIT_MESSAGE, ERROR_MESSAGE, LAST_UPDATED, EXTERNAL_EXECUTION_ID, PARENT_EXECUTION_ID ";
    public static final String FROM_CLAUSE = "%PREFIX%EXECUTION";
    public static final String RUNNING_TASK_WHERE_CLAUSE = "where TASK_NAME = :taskName AND END_TIME IS NULL ";
    public static final String TASK_NAME_WHERE_CLAUSE = "where TASK_NAME = :taskName ";
    private static final String SAVE_TASK_EXECUTION = "INSERT into %PREFIX%EXECUTION(TASK_EXECUTION_ID, EXIT_CODE, START_TIME, TASK_NAME, LAST_UPDATED, EXTERNAL_EXECUTION_ID, PARENT_EXECUTION_ID)values (:taskExecutionId, :exitCode, :startTime, :taskName, :lastUpdated, :externalExecutionId, :parentExecutionId)";
    private static final String CREATE_TASK_ARGUMENT = "INSERT into %PREFIX%EXECUTION_PARAMS(TASK_EXECUTION_ID, TASK_PARAM ) values (:taskExecutionId, :taskParam)";
    private static final String START_TASK_EXECUTION_PREFIX = "UPDATE %PREFIX%EXECUTION set START_TIME = :startTime, TASK_NAME = :taskName, LAST_UPDATED = :lastUpdated";
    private static final String START_TASK_EXECUTION_EXTERNAL_ID_SUFFIX = ", EXTERNAL_EXECUTION_ID = :externalExecutionId, PARENT_EXECUTION_ID = :parentExecutionId where TASK_EXECUTION_ID = :taskExecutionId";
    private static final String START_TASK_EXECUTION_SUFFIX = ", PARENT_EXECUTION_ID = :parentExecutionId where TASK_EXECUTION_ID = :taskExecutionId";
    private static final String CHECK_TASK_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%EXECUTION WHERE TASK_EXECUTION_ID = :taskExecutionId";
    private static final String UPDATE_TASK_EXECUTION = "UPDATE %PREFIX%EXECUTION set END_TIME = :endTime, EXIT_CODE = :exitCode, EXIT_MESSAGE = :exitMessage, ERROR_MESSAGE = :errorMessage, LAST_UPDATED = :lastUpdated where TASK_EXECUTION_ID = :taskExecutionId";
    private static final String UPDATE_TASK_EXECUTION_EXTERNAL_EXECUTION_ID = "UPDATE %PREFIX%EXECUTION set EXTERNAL_EXECUTION_ID = :externalExecutionId where TASK_EXECUTION_ID = :taskExecutionId";
    private static final String GET_EXECUTION_BY_ID = "SELECT TASK_EXECUTION_ID, START_TIME, END_TIME, TASK_NAME, EXIT_CODE, EXIT_MESSAGE, ERROR_MESSAGE, LAST_UPDATED, EXTERNAL_EXECUTION_ID, PARENT_EXECUTION_ID from %PREFIX%EXECUTION where TASK_EXECUTION_ID = :taskExecutionId";
    private static final String FIND_ARGUMENT_FROM_ID = "SELECT TASK_EXECUTION_ID, TASK_PARAM from %PREFIX%EXECUTION_PARAMS where TASK_EXECUTION_ID = :taskExecutionId";
    private static final String TASK_EXECUTION_COUNT = "SELECT COUNT(*) FROM %PREFIX%EXECUTION ";
    private static final String TASK_EXECUTION_COUNT_BY_NAME = "SELECT COUNT(*) FROM %PREFIX%EXECUTION where TASK_NAME = :taskName";
    private static final String RUNNING_TASK_EXECUTION_COUNT_BY_NAME = "SELECT COUNT(*) FROM %PREFIX%EXECUTION where TASK_NAME = :taskName AND END_TIME IS NULL ";
    private static final String RUNNING_TASK_EXECUTION_COUNT = "SELECT COUNT(*) FROM %PREFIX%EXECUTION where END_TIME IS NULL ";
    private static final String LAST_TASK_EXECUTIONS_BY_TASK_NAMES = "select TE2.* from (select MAX(TE.TASK_EXECUTION_ID) as TASK_EXECUTION_ID, TE.TASK_NAME, TE.START_TIME from (select TASK_NAME, MAX(START_TIME) as START_TIME      FROM %PREFIX%EXECUTION where TASK_NAME in (:taskNames)      GROUP BY TASK_NAME) TE_MAX inner join %PREFIX%EXECUTION TE ON TE.TASK_NAME = TE_MAX.TASK_NAME AND TE.START_TIME = TE_MAX.START_TIME group by TE.TASK_NAME, TE.START_TIME) TE1 inner join %PREFIX%EXECUTION TE2 ON TE1.TASK_EXECUTION_ID = TE2.TASK_EXECUTION_ID order by TE2.START_TIME DESC, TE2.TASK_EXECUTION_ID DESC";
    private static final String FIND_TASK_NAMES = "SELECT distinct TASK_NAME from %PREFIX%EXECUTION order by TASK_NAME";
    private static final String FIND_TASK_EXECUTION_BY_JOB_EXECUTION_ID = "SELECT TASK_EXECUTION_ID FROM %PREFIX%TASK_BATCH WHERE JOB_EXECUTION_ID = :jobExecutionId";
    private static final String FIND_JOB_EXECUTION_BY_TASK_EXECUTION_ID = "SELECT JOB_EXECUTION_ID FROM %PREFIX%TASK_BATCH WHERE TASK_EXECUTION_ID = :taskExecutionId";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private String tablePrefix = "TASK_";
    private DataSource dataSource;
    private LinkedHashMap<String, Order> orderMap;
    private DataFieldMaxValueIncrementer taskIncrementer;
    private static final Set<String> validSortColumns = new HashSet<String>(10);

    public JdbcTaskExecutionDao(DataSource dataSource, String tablePrefix) {
        this(dataSource);
        Assert.hasText((String)tablePrefix, (String)"tablePrefix must not be null nor empty");
        this.tablePrefix = tablePrefix;
    }

    public JdbcTaskExecutionDao(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"The dataSource must not be null.");
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        this.dataSource = dataSource;
        this.orderMap = new LinkedHashMap();
        this.orderMap.put("START_TIME", Order.DESCENDING);
        this.orderMap.put("TASK_EXECUTION_ID", Order.DESCENDING);
    }

    @Override
    public TaskExecution createTaskExecution(String taskName, Date startTime, List<String> arguments, String externalExecutionId) {
        return this.createTaskExecution(taskName, startTime, arguments, externalExecutionId, null);
    }

    @Override
    public TaskExecution createTaskExecution(String taskName, Date startTime, List<String> arguments, String externalExecutionId, Long parentExecutionId) {
        long nextExecutionId = this.getNextExecutionId();
        TaskExecution taskExecution = new TaskExecution(nextExecutionId, null, taskName, startTime, null, null, arguments, null, externalExecutionId);
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskExecutionId", (Object)nextExecutionId, -5).addValue("exitCode", null, 4).addValue("startTime", (Object)startTime, 93).addValue("taskName", (Object)taskName, 12).addValue("lastUpdated", (Object)new Date(), 93).addValue("externalExecutionId", (Object)externalExecutionId, 12).addValue("parentExecutionId", (Object)parentExecutionId, -5);
        this.jdbcTemplate.update(this.getQuery(SAVE_TASK_EXECUTION), (SqlParameterSource)queryParameters);
        this.insertTaskArguments(nextExecutionId, arguments);
        return taskExecution;
    }

    @Override
    public TaskExecution startTaskExecution(long executionId, String taskName, Date startTime, List<String> arguments, String externalExecutionId) {
        return this.startTaskExecution(executionId, taskName, startTime, arguments, externalExecutionId, null);
    }

    @Override
    public TaskExecution startTaskExecution(long executionId, String taskName, Date startTime, List<String> arguments, String externalExecutionId, Long parentExecutionId) {
        TaskExecution taskExecution = new TaskExecution(executionId, null, taskName, startTime, null, null, arguments, null, externalExecutionId, parentExecutionId);
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("startTime", (Object)startTime, 93).addValue("exitCode", null, 4).addValue("taskName", (Object)taskName, 12).addValue("lastUpdated", (Object)new Date(), 93).addValue("parentExecutionId", (Object)parentExecutionId, -5).addValue("taskExecutionId", (Object)executionId, -5);
        String updateString = START_TASK_EXECUTION_PREFIX;
        if (externalExecutionId == null) {
            updateString = updateString + START_TASK_EXECUTION_SUFFIX;
        } else {
            updateString = updateString + START_TASK_EXECUTION_EXTERNAL_ID_SUFFIX;
            queryParameters.addValue("externalExecutionId", (Object)externalExecutionId, 12);
        }
        this.jdbcTemplate.update(this.getQuery(updateString), (SqlParameterSource)queryParameters);
        this.insertTaskArguments(executionId, arguments);
        return taskExecution;
    }

    @Override
    public void completeTaskExecution(long taskExecutionId, Integer exitCode, Date endTime, String exitMessage, String errorMessage) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskExecutionId", (Object)taskExecutionId, -5);
        if ((Integer)this.jdbcTemplate.queryForObject(this.getQuery(CHECK_TASK_EXECUTION_EXISTS), (SqlParameterSource)queryParameters, Integer.class) != 1) {
            throw new IllegalStateException("Invalid TaskExecution, ID " + taskExecutionId + " not found.");
        }
        MapSqlParameterSource parameters = new MapSqlParameterSource().addValue("endTime", (Object)endTime, 93).addValue("exitCode", (Object)exitCode, 4).addValue("exitMessage", (Object)exitMessage, 12).addValue("errorMessage", (Object)errorMessage, 12).addValue("lastUpdated", (Object)new Date(), 93).addValue("taskExecutionId", (Object)taskExecutionId, -5);
        this.jdbcTemplate.update(this.getQuery(UPDATE_TASK_EXECUTION), (SqlParameterSource)parameters);
    }

    @Override
    public void completeTaskExecution(long taskExecutionId, Integer exitCode, Date endTime, String exitMessage) {
        this.completeTaskExecution(taskExecutionId, exitCode, endTime, exitMessage, null);
    }

    @Override
    public TaskExecution getTaskExecution(long executionId) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskExecutionId", (Object)executionId, -5);
        try {
            TaskExecution taskExecution = (TaskExecution)this.jdbcTemplate.queryForObject(this.getQuery(GET_EXECUTION_BY_ID), (SqlParameterSource)queryParameters, (RowMapper)new TaskExecutionRowMapper());
            taskExecution.setArguments(this.getTaskArguments(executionId));
            return taskExecution;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public long getTaskExecutionCountByTaskName(String taskName) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskName", (Object)taskName, 12);
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(TASK_EXECUTION_COUNT_BY_NAME), (SqlParameterSource)queryParameters, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public long getRunningTaskExecutionCountByTaskName(String taskName) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskName", (Object)taskName, 12);
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(RUNNING_TASK_EXECUTION_COUNT_BY_NAME), (SqlParameterSource)queryParameters, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public long getRunningTaskExecutionCount() {
        try {
            MapSqlParameterSource queryParameters = new MapSqlParameterSource();
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(RUNNING_TASK_EXECUTION_COUNT), (SqlParameterSource)queryParameters, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public List<TaskExecution> getLatestTaskExecutionsByTaskNames(String ... taskNames) {
        Assert.notEmpty((Object[])taskNames, (String)"At least 1 task name must be provided.");
        ArrayList<String> taskNamesAsList = new ArrayList<String>();
        for (String taskName : taskNames) {
            if (!StringUtils.hasText((String)taskName)) continue;
            taskNamesAsList.add(taskName);
        }
        Assert.isTrue((taskNamesAsList.size() == taskNames.length ? 1 : 0) != 0, (String)String.format("Task names must not contain any empty elements but %s of %s were empty or null.", taskNames.length - taskNamesAsList.size(), taskNames.length));
        try {
            Map paramMap = Collections.singletonMap("taskNames", taskNamesAsList);
            return this.jdbcTemplate.query(this.getQuery(LAST_TASK_EXECUTIONS_BY_TASK_NAMES), paramMap, (RowMapper)new TaskExecutionRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public TaskExecution getLatestTaskExecutionForTaskName(String taskName) {
        Assert.hasText((String)taskName, (String)"The task name must not be empty.");
        List<TaskExecution> taskExecutions = this.getLatestTaskExecutionsByTaskNames(taskName);
        if (taskExecutions.isEmpty()) {
            return null;
        }
        if (taskExecutions.size() == 1) {
            return taskExecutions.get(0);
        }
        throw new IllegalStateException("Only expected a single TaskExecution but received " + taskExecutions.size());
    }

    @Override
    public long getTaskExecutionCount() {
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(TASK_EXECUTION_COUNT), (SqlParameterSource)new MapSqlParameterSource(), Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0L;
        }
    }

    @Override
    public Page<TaskExecution> findRunningTaskExecutions(String taskName, Pageable pageable) {
        return this.queryForPageableResults(pageable, SELECT_CLAUSE, FROM_CLAUSE, RUNNING_TASK_WHERE_CLAUSE, new MapSqlParameterSource("taskName", (Object)taskName), this.getRunningTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public Page<TaskExecution> findTaskExecutionsByName(String taskName, Pageable pageable) {
        return this.queryForPageableResults(pageable, SELECT_CLAUSE, FROM_CLAUSE, TASK_NAME_WHERE_CLAUSE, new MapSqlParameterSource("taskName", (Object)taskName), this.getTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public List<String> getTaskNames() {
        return this.jdbcTemplate.queryForList(this.getQuery(FIND_TASK_NAMES), (SqlParameterSource)new MapSqlParameterSource(), String.class);
    }

    @Override
    public Page<TaskExecution> findAll(Pageable pageable) {
        return this.queryForPageableResults(pageable, SELECT_CLAUSE, FROM_CLAUSE, null, new MapSqlParameterSource(), this.getTaskExecutionCount());
    }

    public void setTaskIncrementer(DataFieldMaxValueIncrementer taskIncrementer) {
        this.taskIncrementer = taskIncrementer;
    }

    @Override
    public long getNextExecutionId() {
        return this.taskIncrementer.nextLongValue();
    }

    @Override
    public Long getTaskExecutionIdByJobExecutionId(long jobExecutionId) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("jobExecutionId", (Object)jobExecutionId, -5);
        try {
            return (Long)this.jdbcTemplate.queryForObject(this.getQuery(FIND_TASK_EXECUTION_BY_JOB_EXECUTION_ID), (SqlParameterSource)queryParameters, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Set<Long> getJobExecutionIdsByTaskExecutionId(long taskExecutionId) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskExecutionId", (Object)taskExecutionId, -5);
        try {
            return (Set)this.jdbcTemplate.query(this.getQuery(FIND_JOB_EXECUTION_BY_TASK_EXECUTION_ID), (SqlParameterSource)queryParameters, (ResultSetExtractor)new ResultSetExtractor<Set<Long>>(){

                public Set<Long> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                    TreeSet<Long> jobExecutionIds = new TreeSet<Long>();
                    while (resultSet.next()) {
                        jobExecutionIds.add(resultSet.getLong("JOB_EXECUTION_ID"));
                    }
                    return jobExecutionIds;
                }
            });
        }
        catch (DataAccessException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public void updateExternalExecutionId(long taskExecutionId, String externalExecutionId) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("externalExecutionId", (Object)externalExecutionId, 12).addValue("taskExecutionId", (Object)taskExecutionId, -5);
        if (this.jdbcTemplate.update(this.getQuery(UPDATE_TASK_EXECUTION_EXTERNAL_EXECUTION_ID), (SqlParameterSource)queryParameters) != 1) {
            throw new IllegalStateException("Invalid TaskExecution, ID " + taskExecutionId + " not found.");
        }
    }

    private Page<TaskExecution> queryForPageableResults(Pageable pageable, String selectClause, String fromClause, String whereClause, MapSqlParameterSource queryParameters, long totalCount) {
        PagingQueryProvider pagingQueryProvider;
        SqlPagingQueryProviderFactoryBean factoryBean = new SqlPagingQueryProviderFactoryBean();
        factoryBean.setSelectClause(selectClause);
        factoryBean.setFromClause(fromClause);
        if (StringUtils.hasText((String)whereClause)) {
            factoryBean.setWhereClause(whereClause);
        }
        Sort sort = pageable.getSort();
        LinkedHashMap<String, Order> sortOrderMap = new LinkedHashMap<String, Order>();
        if (sort != null) {
            for (Sort.Order sortOrder : sort) {
                if (validSortColumns.contains(sortOrder.getProperty().toUpperCase())) {
                    sortOrderMap.put(sortOrder.getProperty(), sortOrder.isAscending() ? Order.ASCENDING : Order.DESCENDING);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid sort option selected: %s", sortOrder.getProperty()));
            }
        }
        if (!CollectionUtils.isEmpty(sortOrderMap)) {
            factoryBean.setSortKeys(sortOrderMap);
        } else {
            factoryBean.setSortKeys(this.orderMap);
        }
        factoryBean.setDataSource(this.dataSource);
        try {
            pagingQueryProvider = factoryBean.getObject();
            pagingQueryProvider.init(this.dataSource);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        String query = pagingQueryProvider.getPageQuery(pageable);
        List resultList = this.jdbcTemplate.query(this.getQuery(query), (SqlParameterSource)queryParameters, (RowMapper)new TaskExecutionRowMapper());
        return new PageImpl(resultList, pageable, totalCount);
    }

    private String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%PREFIX%", (String)this.tablePrefix);
    }

    private void insertTaskArguments(long executionId, List<String> taskArguments) {
        for (String args : taskArguments) {
            this.insertArgument(executionId, args);
        }
    }

    private void insertArgument(long taskExecutionId, String taskParam) {
        MapSqlParameterSource queryParameters = new MapSqlParameterSource().addValue("taskExecutionId", (Object)taskExecutionId, -5).addValue("taskParam", (Object)taskParam, 12);
        this.jdbcTemplate.update(this.getQuery(CREATE_TASK_ARGUMENT), (SqlParameterSource)queryParameters);
    }

    private List<String> getTaskArguments(long taskExecutionId) {
        final ArrayList<String> params = new ArrayList<String>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                params.add(rs.getString(2));
            }
        };
        this.jdbcTemplate.query(this.getQuery(FIND_ARGUMENT_FROM_ID), (SqlParameterSource)new MapSqlParameterSource("taskExecutionId", (Object)taskExecutionId), handler);
        return params;
    }

    static {
        validSortColumns.add("TASK_EXECUTION_ID");
        validSortColumns.add("START_TIME");
        validSortColumns.add("END_TIME");
        validSortColumns.add("TASK_NAME");
        validSortColumns.add("EXIT_CODE");
        validSortColumns.add("EXIT_MESSAGE");
        validSortColumns.add("ERROR_MESSAGE");
        validSortColumns.add("LAST_UPDATED");
        validSortColumns.add("EXTERNAL_EXECUTION_ID");
        validSortColumns.add("PARENT_EXECUTION_ID");
    }

    private final class TaskExecutionRowMapper
    implements RowMapper<TaskExecution> {
        private TaskExecutionRowMapper() {
        }

        public TaskExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            long id = rs.getLong("TASK_EXECUTION_ID");
            Long parentExecutionId = rs.getLong("PARENT_EXECUTION_ID");
            if (rs.wasNull()) {
                parentExecutionId = null;
            }
            return new TaskExecution(id, this.getNullableExitCode(rs), rs.getString("TASK_NAME"), rs.getTimestamp("START_TIME"), rs.getTimestamp("END_TIME"), rs.getString("EXIT_MESSAGE"), JdbcTaskExecutionDao.this.getTaskArguments(id), rs.getString("ERROR_MESSAGE"), rs.getString("EXTERNAL_EXECUTION_ID"), parentExecutionId);
        }

        private Integer getNullableExitCode(ResultSet rs) throws SQLException {
            int exitCode = rs.getInt("EXIT_CODE");
            return !rs.wasNull() ? Integer.valueOf(exitCode) : null;
        }
    }
}

