/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.support;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.StringUtils;

public enum DatabaseType {
    HSQL("HSQL Database Engine"),
    H2("H2"),
    ORACLE("Oracle"),
    MYSQL("MySQL"),
    POSTGRES("PostgreSQL"),
    SQLSERVER("Microsoft SQL Server"),
    DB2("DB2"),
    DB2VSE("DB2VSE"),
    DB2ZOS("DB2ZOS"),
    DB2AS400("DB2AS400");

    private static final Map<String, DatabaseType> dbNameMap;
    private final String productName;

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public static DatabaseType fromMetaData(DataSource dataSource) throws MetaDataAccessException {
        String databaseProductVersion;
        String databaseProductName = JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductName").toString();
        databaseProductName = StringUtils.hasText((String)databaseProductName) && !databaseProductName.equals("DB2/Linux") && databaseProductName.startsWith("DB2") ? ((databaseProductVersion = JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductVersion").toString()).startsWith("ARI") ? "DB2VSE" : (databaseProductVersion.startsWith("DSN") ? "DB2ZOS" : (databaseProductName.indexOf("AS") != -1 && (databaseProductVersion.startsWith("QSQ") || databaseProductVersion.substring(databaseProductVersion.indexOf(86)).matches("V\\dR\\d[mM]\\d")) ? "DB2AS400" : JdbcUtils.commonDatabaseName((String)databaseProductName)))) : JdbcUtils.commonDatabaseName((String)databaseProductName);
        return DatabaseType.fromProductName(databaseProductName);
    }

    public static DatabaseType fromProductName(String productName) {
        if (productName.equals("MariaDB")) {
            productName = "MySQL";
        }
        if (!dbNameMap.containsKey(productName)) {
            throw new IllegalArgumentException("DatabaseType not found for product name: [" + productName + "]");
        }
        return dbNameMap.get(productName);
    }

    private String getProductName() {
        return this.productName;
    }

    static {
        dbNameMap = new HashMap<String, DatabaseType>();
        for (DatabaseType type : DatabaseType.values()) {
            dbNameMap.put(type.getProductName(), type);
        }
    }
}

