/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Timed.class})
@AutoConfigureBefore(name={"org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration"})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClockFork() {
        return Clock.SYSTEM;
    }

    @Bean
    public static MeterRegistryPostProcessor meterRegistryPostProcessorFork() {
        return new MeterRegistryPostProcessor();
    }

    static class MeterRegistryPostProcessor
    implements BeanPostProcessor,
    EnvironmentAware {
        private Environment environment;
        @Value(value="${spring.cloud.task.name:unknown}")
        private String taskName;
        @Value(value="${spring.cloud.task.executionid:unknown}")
        private String taskExecutionId;
        @Value(value="${spring.cloud.task.external-execution-id:unknown}")
        private String taskExternalExecutionId;
        @Value(value="${spring.cloud.task.parent-execution-id:unknown}")
        private String taskParentExecutionId;
        @Value(value="${vcap.application.org_name:default}")
        private String organizationName;
        @Value(value="${vcap.application.space_id:unknown}")
        private String spaceId;
        @Value(value="${vcap.application.space_name:unknown}")
        private String spaceName;
        @Value(value="${vcap.application.application_name:unknown}")
        private String applicationName;
        @Value(value="${vcap.application.application_id:unknown}")
        private String applicationId;
        @Value(value="${vcap.application.application_version:unknown}")
        private String applicationVersion;
        @Value(value="${vcap.application.instance_index:0}")
        private String instanceIndex;

        MeterRegistryPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof MeterRegistry) {
                MeterRegistry registry = (MeterRegistry)bean;
                if (Arrays.asList(this.environment.getActiveProfiles()).contains("cloud")) {
                    registry.config().commonTags(new String[]{"cf.org.name", this.organizationName}).commonTags(new String[]{"cf.space.id", this.spaceId}).commonTags(new String[]{"cf.space.name", this.spaceName}).commonTags(new String[]{"cf.app.id", this.applicationId}).commonTags(new String[]{"cf.app.name", this.applicationName}).commonTags(new String[]{"cf.app.version", this.applicationVersion}).commonTags(new String[]{"cf.instance.index", this.instanceIndex});
                }
                registry.config().commonTags(new String[]{"task.name", this.taskName}).commonTags(new String[]{"task.execution.id", this.taskExecutionId}).commonTags(new String[]{"task.external.execution.id", this.taskExternalExecutionId}).commonTags(new String[]{"task.parent.execution.id", this.taskParentExecutionId});
            }
            return bean;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }
    }
}

