/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.util.Assert;

public class TaskExecution {
    private long executionId;
    private Long parentExecutionId;
    private Integer exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private String externalExecutionId;
    private String errorMessage;
    private List<String> arguments;

    public TaskExecution() {
        this.arguments = new ArrayList<String>();
    }

    public TaskExecution(long executionId, Integer exitCode, String taskName, Date startTime, Date endTime, String exitMessage, List<String> arguments, String errorMessage, String externalExecutionId, Long parentExecutionId) {
        Assert.notNull(arguments, (String)"arguments must not be null");
        this.executionId = executionId;
        this.exitCode = exitCode;
        this.taskName = taskName;
        this.exitMessage = exitMessage;
        this.arguments = new ArrayList<String>(arguments);
        this.startTime = startTime != null ? (Date)startTime.clone() : null;
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
        this.errorMessage = errorMessage;
        this.externalExecutionId = externalExecutionId;
        this.parentExecutionId = parentExecutionId;
    }

    public TaskExecution(long executionId, Integer exitCode, String taskName, Date startTime, Date endTime, String exitMessage, List<String> arguments, String errorMessage, String externalExecutionId) {
        this(executionId, exitCode, taskName, startTime, endTime, exitMessage, arguments, errorMessage, externalExecutionId, null);
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime != null ? (Date)startTime.clone() : null;
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public void setExitMessage(String exitMessage) {
        this.exitMessage = exitMessage;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = new ArrayList<String>(arguments);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public void setExternalExecutionId(String externalExecutionId) {
        this.externalExecutionId = externalExecutionId;
    }

    public Long getParentExecutionId() {
        return this.parentExecutionId;
    }

    public void setParentExecutionId(Long parentExecutionId) {
        this.parentExecutionId = parentExecutionId;
    }

    public String toString() {
        return "TaskExecution{executionId=" + this.executionId + ", parentExecutionId=" + this.parentExecutionId + ", exitCode=" + this.exitCode + ", taskName='" + this.taskName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", exitMessage='" + this.exitMessage + '\'' + ", externalExecutionId='" + this.externalExecutionId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", arguments=" + this.arguments + '}';
    }
}

