/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.task.configuration.SingleInstanceTaskListener;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.repository.TaskNameResolver;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.support.locks.PassThruLockRegistry;

@Order(value=-2147483648)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.cloud.task", name={"single-instance-enabled"}, havingValue="true")
public class SingleTaskConfiguration {
    @Autowired
    private TaskProperties taskProperties;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private TaskConfigurer taskConfigurer;

    @Bean
    public SingleInstanceTaskListener taskListener(TaskNameResolver resolver) {
        if (this.taskConfigurer.getTaskDataSource() == null) {
            return new SingleInstanceTaskListener((LockRegistry)new PassThruLockRegistry(), resolver, this.taskProperties, this.applicationEventPublisher);
        }
        return new SingleInstanceTaskListener(this.taskConfigurer.getTaskDataSource(), resolver, this.taskProperties, this.applicationEventPublisher);
    }
}

