/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.task.listener.TaskExecutionException;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.repository.TaskExecution;

public class TaskListenerExecutor
implements TaskExecutionListener {
    private Map<Method, Set<Object>> beforeTaskInstances;
    private Map<Method, Set<Object>> afterTaskInstances;
    private Map<Method, Set<Object>> failedTaskInstances;

    public TaskListenerExecutor(Map<Method, Set<Object>> beforeTaskInstances, Map<Method, Set<Object>> afterTaskInstances, Map<Method, Set<Object>> failedTaskInstances) {
        this.beforeTaskInstances = beforeTaskInstances;
        this.afterTaskInstances = afterTaskInstances;
        this.failedTaskInstances = failedTaskInstances;
    }

    @Override
    public void onTaskStartup(TaskExecution taskExecution) {
        this.executeTaskListener(taskExecution, this.beforeTaskInstances.keySet(), this.beforeTaskInstances);
    }

    @Override
    public void onTaskEnd(TaskExecution taskExecution) {
        this.executeTaskListener(taskExecution, this.afterTaskInstances.keySet(), this.afterTaskInstances);
    }

    @Override
    public void onTaskFailed(TaskExecution taskExecution, Throwable throwable) {
        this.executeTaskListenerWithThrowable(taskExecution, throwable, this.failedTaskInstances.keySet(), this.failedTaskInstances);
    }

    private void executeTaskListener(TaskExecution taskExecution, Set<Method> methods, Map<Method, Set<Object>> instances) {
        for (Method method : methods) {
            for (Object instance : instances.get(method)) {
                try {
                    method.invoke(instance, taskExecution);
                }
                catch (IllegalAccessException e) {
                    throw new TaskExecutionException("@BeforeTask and @AfterTask annotated methods must be public.", e);
                }
                catch (InvocationTargetException e) {
                    throw new TaskExecutionException(String.format("Failed to process @BeforeTask or @AfterTask annotation because: %s", e.getTargetException().getMessage()), e);
                }
                catch (IllegalArgumentException e) {
                    throw new TaskExecutionException("taskExecution parameter is required for @BeforeTask and @AfterTask annotated methods", e);
                }
            }
        }
    }

    private void executeTaskListenerWithThrowable(TaskExecution taskExecution, Throwable throwable, Set<Method> methods, Map<Method, Set<Object>> instances) {
        for (Method method : methods) {
            for (Object instance : instances.get(method)) {
                try {
                    method.invoke(instance, taskExecution, throwable);
                }
                catch (IllegalAccessException e) {
                    throw new TaskExecutionException("@FailedTask annotated methods must be public.", e);
                }
                catch (InvocationTargetException e) {
                    throw new TaskExecutionException(String.format("Failed to process @FailedTask annotation because: %s", e.getTargetException().getMessage()), e);
                }
                catch (IllegalArgumentException e) {
                    throw new TaskExecutionException("taskExecution and throwable parameters are required for @FailedTask annotated methods", e);
                }
            }
        }
    }
}

