/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.support;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.listener.TaskException;
import org.springframework.cloud.task.repository.dao.JdbcTaskExecutionDao;
import org.springframework.cloud.task.repository.dao.MapTaskExecutionDao;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.cloud.task.repository.support.DatabaseType;
import org.springframework.cloud.task.repository.support.SqlServerSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskExecutionDaoFactoryBean
implements FactoryBean<TaskExecutionDao> {
    private DataSource dataSource;
    private TaskExecutionDao dao = null;
    private String tablePrefix = "TASK_";

    public TaskExecutionDaoFactoryBean() {
    }

    public TaskExecutionDaoFactoryBean(DataSource dataSource, String tablePrefix) {
        this(dataSource);
        Assert.hasText((String)tablePrefix, (String)"tablePrefix must not be null nor empty");
        this.tablePrefix = tablePrefix;
    }

    public TaskExecutionDaoFactoryBean(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"A DataSource is required");
        this.dataSource = dataSource;
    }

    public TaskExecutionDao getObject() throws Exception {
        if (this.dao == null) {
            if (this.dataSource != null) {
                this.buildTaskExecutionDao(this.dataSource);
            } else {
                this.dao = new MapTaskExecutionDao();
            }
        }
        if (this.dataSource != null) {
            String databaseType = null;
            try {
                databaseType = DatabaseType.fromMetaData(this.dataSource).name();
            }
            catch (MetaDataAccessException e) {
                throw new IllegalStateException(e);
            }
            if (StringUtils.hasText((String)databaseType) && databaseType.equals("SQLSERVER")) {
                String incrementerName = this.tablePrefix + "SEQ";
                DefaultDataFieldMaxValueIncrementerFactory incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(this.dataSource);
                Object incrementer = incrementerFactory.getIncrementer(databaseType, incrementerName);
                if (!this.isSqlServerTableSequenceAvailable(incrementerName)) {
                    incrementer = new SqlServerSequenceMaxValueIncrementer(this.dataSource, this.tablePrefix + "SEQ");
                }
                ((JdbcTaskExecutionDao)this.dao).setTaskIncrementer((DataFieldMaxValueIncrementer)incrementer);
            }
        }
        return this.dao;
    }

    public Class<?> getObjectType() {
        return TaskExecutionDao.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void buildTaskExecutionDao(DataSource dataSource) {
        String databaseType;
        DefaultDataFieldMaxValueIncrementerFactory incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(dataSource);
        this.dao = new JdbcTaskExecutionDao(dataSource, this.tablePrefix);
        try {
            databaseType = DatabaseType.fromMetaData(dataSource).name();
        }
        catch (MetaDataAccessException e) {
            throw new IllegalStateException(e);
        }
        ((JdbcTaskExecutionDao)this.dao).setTaskIncrementer(incrementerFactory.getIncrementer(databaseType, this.tablePrefix + "SEQ"));
    }

    private boolean isSqlServerTableSequenceAvailable(String incrementerName) {
        boolean result = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = this.dataSource.getConnection().getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet tables = metaData.getTables(null, null, "%", types);
            while (tables.next()) {
                if (!tables.getString("TABLE_NAME").equals(incrementerName)) continue;
                result = true;
                break;
            }
        }
        catch (SQLException sqe) {
            throw new TaskException(sqe.getMessage());
        }
        return result;
    }
}

