/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import jakarta.persistence.EntityManager;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.cloud.task.repository.support.SimpleTaskExplorer;
import org.springframework.cloud.task.repository.support.SimpleTaskRepository;
import org.springframework.cloud.task.repository.support.TaskExecutionDaoFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultTaskConfigurer
implements TaskConfigurer {
    private static final Log logger = LogFactory.getLog(DefaultTaskConfigurer.class);
    private TaskRepository taskRepository;
    private TaskExplorer taskExplorer;
    private PlatformTransactionManager transactionManager;
    private DataSource dataSource;
    private ApplicationContext context;

    public DefaultTaskConfigurer() {
        this("TASK_");
    }

    public DefaultTaskConfigurer(DataSource dataSource) {
        this(dataSource, "TASK_", null);
    }

    public DefaultTaskConfigurer(String tablePrefix) {
        this(null, tablePrefix, null);
    }

    public DefaultTaskConfigurer(DataSource dataSource, String tablePrefix, ApplicationContext context) {
        this.dataSource = dataSource;
        this.context = context;
        TaskExecutionDaoFactoryBean taskExecutionDaoFactoryBean = this.dataSource != null ? new TaskExecutionDaoFactoryBean(this.dataSource, tablePrefix) : new TaskExecutionDaoFactoryBean();
        this.taskRepository = new SimpleTaskRepository(taskExecutionDaoFactoryBean);
        this.taskExplorer = new SimpleTaskExplorer(taskExecutionDaoFactoryBean);
    }

    @Override
    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    @Override
    public TaskExplorer getTaskExplorer() {
        return this.taskExplorer;
    }

    @Override
    public DataSource getTaskDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager != null) return this.transactionManager;
        if (this.isDataSourceAvailable()) {
            try {
                Class.forName("javax.persistence.EntityManager");
                if (this.context == null || this.context.getBeanNamesForType(EntityManager.class).length <= 0) return this.transactionManager;
                logger.debug((Object)"EntityManager was found, using JpaTransactionManager");
                this.transactionManager = new JpaTransactionManager();
                return this.transactionManager;
            }
            catch (ClassNotFoundException ignore) {
                logger.debug((Object)"No EntityManager was found, using DataSourceTransactionManager");
                return this.transactionManager;
            }
            finally {
                if (this.transactionManager == null) {
                    this.transactionManager = new JdbcTransactionManager(this.dataSource);
                }
            }
        } else {
            logger.debug((Object)"No DataSource was found, using ResourcelessTransactionManager");
            this.transactionManager = new ResourcelessTransactionManager();
        }
        return this.transactionManager;
    }

    private boolean isDataSourceAvailable() {
        return this.dataSource != null;
    }
}

