/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.cloud.task.configuration.DefaultTaskConfigurer;
import org.springframework.cloud.task.configuration.NoTransactionManagerProperty;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.configuration.TaskObservationCloudKeyValues;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.TaskNameResolver;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.cloud.task.repository.support.SimpleTaskNameResolver;
import org.springframework.cloud.task.repository.support.SimpleTaskRepository;
import org.springframework.cloud.task.repository.support.TaskRepositoryInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.CollectionUtils;

@AutoConfiguration
@EnableTransactionManagement
@EnableConfigurationProperties(value={TaskProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.task.autoconfiguration", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={DatabaseInitializationDependencyConfigurer.class})
public class SimpleTaskAutoConfiguration {
    protected static final Log logger = LogFactory.getLog(SimpleTaskAutoConfiguration.class);
    @Autowired(required=false)
    private Collection<DataSource> dataSources;
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private TaskProperties taskProperties;
    private boolean initialized = false;
    private TaskRepository taskRepository;
    private PlatformTransactionManager platformTransactionManager;
    private TaskExplorer taskExplorer;

    @Bean
    public SimpleTaskRepository taskRepository() {
        return (SimpleTaskRepository)this.taskRepository;
    }

    @Conditional(value={NoTransactionManagerProperty.class})
    @Bean
    public PlatformTransactionManager springCloudTaskTransactionManager() {
        return this.platformTransactionManager;
    }

    @Bean
    public TaskExplorer taskExplorer() {
        return this.taskExplorer;
    }

    @Bean
    public TaskNameResolver taskNameResolver() {
        return new SimpleTaskNameResolver();
    }

    @Bean
    public TaskRepositoryInitializer taskRepositoryInitializer() {
        TaskRepositoryInitializer taskRepositoryInitializer = new TaskRepositoryInitializer(this.taskProperties);
        DataSource initializerDataSource = this.getDefaultConfigurer().getTaskDataSource();
        if (initializerDataSource != null) {
            taskRepositoryInitializer.setDataSource(initializerDataSource);
        }
        return taskRepositoryInitializer;
    }

    @Bean
    @Profile(value={"cloud"})
    TaskObservationCloudKeyValues taskObservationCloudKeyValues() {
        return new TaskObservationCloudKeyValues();
    }

    @PostConstruct
    protected void initialize() {
        if (this.initialized) {
            return;
        }
        TaskConfigurer taskConfigurer = this.getDefaultConfigurer();
        logger.debug((Object)String.format("Using %s TaskConfigurer", taskConfigurer.getClass().getName()));
        this.taskRepository = taskConfigurer.getTaskRepository();
        this.platformTransactionManager = taskConfigurer.getTransactionManager();
        this.taskExplorer = taskConfigurer.getTaskExplorer();
        this.initialized = true;
    }

    private TaskConfigurer getDefaultConfigurer() {
        this.verifyEnvironment();
        int configurers = this.context.getBeanNamesForType(TaskConfigurer.class).length;
        if (configurers < 1) {
            DefaultTaskConfigurer taskConfigurer = !CollectionUtils.isEmpty(this.dataSources) && this.dataSources.size() == 1 ? new DefaultTaskConfigurer(this.dataSources.iterator().next(), this.taskProperties.getTablePrefix(), (ApplicationContext)this.context) : new DefaultTaskConfigurer(this.taskProperties.getTablePrefix());
            this.context.getBeanFactory().registerSingleton("taskConfigurer", (Object)taskConfigurer);
            return taskConfigurer;
        }
        if (configurers == 1) {
            return (TaskConfigurer)this.context.getBean(TaskConfigurer.class);
        }
        throw new IllegalStateException("Expected one TaskConfigurer but found " + configurers);
    }

    private void verifyEnvironment() {
        int configurers = this.context.getBeanNamesForType(TaskConfigurer.class).length;
        long dataSources = Arrays.stream(this.context.getBeanNamesForType(DataSource.class)).filter(name -> !ScopedProxyUtils.isScopedTarget((String)name)).count();
        if (configurers == 0 && dataSources > 1L) {
            throw new IllegalStateException("To use the default TaskConfigurer the context must contain no more than one DataSource, found " + dataSources);
        }
    }
}

