/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.cloud.task.configuration.TaskObservationCloudKeyValues;
import org.springframework.cloud.task.listener.DefaultTaskExecutionObservationConvention;
import org.springframework.cloud.task.listener.TaskExecutionObservation;
import org.springframework.cloud.task.listener.TaskExecutionObservationContext;
import org.springframework.cloud.task.listener.TaskExecutionObservationConvention;
import org.springframework.cloud.task.repository.TaskExecution;

public class TaskObservations {
    public static final String STATUS_SUCCESS = "success";
    public static final String STATUS_FAILURE = "failure";
    public static final String UNKNOWN = "unknown";
    private ObservationRegistry observationRegistry;
    private ObservationConvention customObservationConvention;
    private Observation.Scope scope;
    private TaskExecutionObservationConvention observationsProvider = new DefaultTaskExecutionObservationConvention();
    private TaskExecutionObservationContext taskObservationContext;
    TaskObservationCloudKeyValues taskObservationCloudKeyValues;

    public TaskObservations(ObservationRegistry observationRegistry, TaskObservationCloudKeyValues taskObservationCloudKeyValues, ObservationConvention customObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.taskObservationCloudKeyValues = taskObservationCloudKeyValues;
        this.customObservationConvention = customObservationConvention;
    }

    public void onTaskStartup(TaskExecution taskExecution) {
        this.taskObservationContext = new TaskExecutionObservationContext(taskExecution);
        Observation observation = TaskExecutionObservation.TASK_ACTIVE.observation(this.customObservationConvention, new DefaultTaskExecutionObservationConvention(), this.taskObservationContext, this.observationRegistry).contextualName(String.valueOf(taskExecution.getExecutionId())).observationConvention((ObservationConvention)this.observationsProvider).lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_NAME.asString(), this.getValueOrDefault(taskExecution.getTaskName())).lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_EXECUTION_ID.asString(), "" + taskExecution.getExecutionId()).lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_PARENT_EXECUTION_ID.asString(), this.getValueOrDefault(taskExecution.getParentExecutionId())).lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_EXTERNAL_EXECUTION_ID.asString(), this.getValueOrDefault(taskExecution.getExternalExecutionId()));
        if (this.taskObservationCloudKeyValues != null) {
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_ORG_NAME.asString(), this.taskObservationCloudKeyValues.getOrganizationName());
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_SPACE_ID.asString(), this.taskObservationCloudKeyValues.getSpaceId());
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_SPACE_NAME.asString(), this.taskObservationCloudKeyValues.getSpaceName());
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_APP_ID.asString(), this.taskObservationCloudKeyValues.getApplicationId());
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_APP_NAME.asString(), this.taskObservationCloudKeyValues.getApplicationName());
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_APP_VERSION.asString(), this.taskObservationCloudKeyValues.getApplicationVersion());
            observation.lowCardinalityKeyValue(TaskExecutionObservation.TaskKeyValues.TASK_CF_INSTANCE_INDEX.asString(), this.taskObservationCloudKeyValues.getInstanceIndex());
        }
        observation.start();
        this.scope = observation.openScope();
    }

    private String getValueOrDefault(Object value) {
        return value != null ? value.toString() : UNKNOWN;
    }

    public void onTaskFailed(Throwable throwable) {
        this.taskObservationContext.setStatus(STATUS_FAILURE);
        this.scope.getCurrentObservation().error(throwable);
    }

    public void onTaskEnd(TaskExecution taskExecution) {
        if (this.scope != null) {
            this.taskObservationContext.getTaskExecution().setExitCode(taskExecution.getExitCode());
            this.scope.close();
            this.scope.getCurrentObservation().stop();
        }
    }
}

