
CREATE TABLE TASK_EXECUTION  (
	TASK_EXECUTION_ID BIGINT NOT NULL PRIMARY KEY ,
	START_TIME DATETIME(6) DEFAULT NULL ,
	END_TIME DATETIME(6) DEFAULT NULL ,
	TASK_NAME  VARCHAR(100) ,
	EXIT_CODE INTEGER ,
	EXIT_MESSAGE VARCHAR(2500) ,
	ERROR_MESSAGE VARCHAR(2500) ,
	LAST_UPDATED TIMESTAMP,
	EXTERNAL_EXECUTION_ID VARCHAR(255),
	PARENT_EXECUTION_ID BIGINT
) ENGINE=InnoDB;

CREATE TABLE TASK_EXECUTION_PARAMS  (
	TASK_EXECUTION_ID BIGINT NOT NULL ,
	TASK_PARAM VARCHAR(2500) ,
	constraint TASK_EXEC_PARAMS_FK foreign key (TASK_EXECUTION_ID)
	references TASK_EXECUTION(TASK_EXECUTION_ID)
) ENGINE=InnoDB;

CREATE TABLE TASK_TASK_BATCH (
 TASK_EXECUTION_ID BIGINT NOT NULL ,
 JOB_EXECUTION_ID BIGINT NOT NULL ,
	constraint TASK_EXEC_BATCH_FK foreign key (TASK_EXECUTION_ID)
	references TASK_EXECUTION(TASK_EXECUTION_ID)
)  ENGINE=InnoDB;

CREATE TABLE TASK_LOCK  (
	LOCK_KEY CHAR(36) NOT NULL,
	REGION VARCHAR(100) NOT NULL,
	CLIENT_ID CHAR(36),
	CREATED_DATE DATETIME(6) NOT NULL,
	constraint LOCK_PK primary key (LOCK_KEY, REGION)
) ENGINE=InnoDB;

CREATE SEQUENCE TASK_SEQ START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775806 INCREMENT BY 1 NOCACHE NOCYCLE ENGINE=InnoDB;
