/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.task.configuration.observation.DefaultTaskObservationConvention;
import org.springframework.cloud.task.configuration.observation.TaskDocumentedObservation;
import org.springframework.cloud.task.configuration.observation.TaskObservationContext;
import org.springframework.cloud.task.configuration.observation.TaskObservationConvention;

class ObservationCommandLineRunner
implements CommandLineRunner {
    private static final DefaultTaskObservationConvention INSTANCE = new DefaultTaskObservationConvention();
    private final BeanFactory beanFactory;
    private final CommandLineRunner delegate;
    private final String beanName;
    private ObservationRegistry registry;
    private TaskObservationConvention taskObservationConvention;

    ObservationCommandLineRunner(BeanFactory beanFactory, CommandLineRunner delegate, String beanName) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = beanName;
    }

    public void run(String ... args) throws Exception {
        TaskObservationContext context = new TaskObservationContext(this.beanName);
        Observation observation = TaskDocumentedObservation.TASK_RUNNER_OBSERVATION.observation(this.taskObservationConvention, INSTANCE, context, this.registry()).contextualName(this.beanName);
        try (Observation.Scope scope = observation.start().openScope();){
            this.delegate.run(args);
        }
        catch (Exception error) {
            observation.error((Throwable)error);
            throw error;
        }
        finally {
            observation.stop();
        }
    }

    private ObservationRegistry registry() {
        if (this.registry == null) {
            this.registry = (ObservationRegistry)this.beanFactory.getBean(ObservationRegistry.class);
        }
        return this.registry;
    }
}

