/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import io.micrometer.common.KeyValues;
import org.springframework.cloud.task.listener.TaskExecutionObservation;
import org.springframework.cloud.task.listener.TaskExecutionObservationContext;
import org.springframework.cloud.task.listener.TaskExecutionObservationConvention;
import org.springframework.cloud.task.repository.TaskExecution;

public class DefaultTaskExecutionObservationConvention
implements TaskExecutionObservationConvention {
    public KeyValues getLowCardinalityKeyValues(TaskExecutionObservationContext context) {
        return this.getKeyValuesForTaskExecution(context);
    }

    public KeyValues getHighCardinalityKeyValues(TaskExecutionObservationContext context) {
        return KeyValues.empty();
    }

    private KeyValues getKeyValuesForTaskExecution(TaskExecutionObservationContext context) {
        TaskExecution execution = context.getTaskExecution();
        return KeyValues.of((String[])new String[]{TaskExecutionObservation.TaskKeyValues.TASK_STATUS.asString(), context.getStatus(), TaskExecutionObservation.TaskKeyValues.TASK_EXIT_CODE.asString(), String.valueOf(execution.getExitCode()), TaskExecutionObservation.TaskKeyValues.TASK_EXECUTION_ID.asString(), String.valueOf(execution.getExecutionId())});
    }

    public String getName() {
        return "spring.cloud.task";
    }
}

