/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import io.micrometer.observation.ObservationRegistry;
import jakarta.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.cloud.task.configuration.TaskObservationCloudKeyValues;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.listener.TaskLifecycleListener;
import org.springframework.cloud.task.listener.TaskListenerExecutorObjectFactory;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.TaskNameResolver;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class TaskLifecycleConfiguration {
    protected static final Log logger = LogFactory.getLog(TaskLifecycleConfiguration.class);
    private TaskProperties taskProperties;
    private ConfigurableApplicationContext context;
    private ApplicationArguments applicationArguments;
    private TaskRepository taskRepository;
    private TaskExplorer taskExplorer;
    private TaskNameResolver taskNameResolver;
    private TaskLifecycleListener taskLifecycleListener;
    private boolean initialized = false;
    private ObservationRegistry observationRegistry;
    private TaskObservationCloudKeyValues taskObservationCloudKeyValues;

    @Autowired
    public TaskLifecycleConfiguration(TaskProperties taskProperties, ConfigurableApplicationContext context, TaskRepository taskRepository, TaskExplorer taskExplorer, TaskNameResolver taskNameResolver, ObjectProvider<ApplicationArguments> applicationArguments, @Autowired(required=false) ObservationRegistry observationRegistry, @Autowired(required=false) TaskObservationCloudKeyValues taskObservationCloudKeyValues) {
        this.taskProperties = taskProperties;
        this.context = context;
        this.taskRepository = taskRepository;
        this.taskExplorer = taskExplorer;
        this.taskNameResolver = taskNameResolver;
        this.applicationArguments = (ApplicationArguments)applicationArguments.getIfAvailable();
        this.observationRegistry = observationRegistry == null ? ObservationRegistry.NOOP : observationRegistry;
        this.taskObservationCloudKeyValues = taskObservationCloudKeyValues;
    }

    @Bean
    public TaskLifecycleListener taskLifecycleListener() {
        return this.taskLifecycleListener;
    }

    @PostConstruct
    protected void initialize() {
        if (!this.initialized) {
            this.taskLifecycleListener = new TaskLifecycleListener(this.taskRepository, this.taskNameResolver, this.applicationArguments, this.taskExplorer, this.taskProperties, new TaskListenerExecutorObjectFactory(this.context), this.observationRegistry, this.taskObservationCloudKeyValues);
            this.initialized = true;
        }
    }
}

