/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.cloud.task.configuration.observation.DefaultTaskObservationConvention;
import org.springframework.cloud.task.configuration.observation.TaskDocumentedObservation;
import org.springframework.cloud.task.configuration.observation.TaskObservationContext;
import org.springframework.cloud.task.configuration.observation.TaskObservationConvention;

class ObservationApplicationRunner
implements ApplicationRunner {
    private static final DefaultTaskObservationConvention INSTANCE = new DefaultTaskObservationConvention();
    private final BeanFactory beanFactory;
    private final ApplicationRunner delegate;
    private final String beanName;
    private ObservationRegistry registry;
    private TaskObservationConvention taskObservationConvention;

    ObservationApplicationRunner(BeanFactory beanFactory, ApplicationRunner delegate, String beanName) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = beanName;
    }

    public void run(ApplicationArguments args) throws Exception {
        TaskObservationContext context = new TaskObservationContext(this.beanName);
        Observation observation = TaskDocumentedObservation.TASK_RUNNER_OBSERVATION.observation(this.taskObservationConvention, INSTANCE, context, this.registry()).contextualName(this.beanName);
        try (Observation.Scope scope = observation.start().openScope();){
            this.delegate.run(args);
        }
        catch (Exception error) {
            observation.error((Throwable)error);
            throw error;
        }
        finally {
            observation.stop();
        }
    }

    private ObservationRegistry registry() {
        if (this.registry == null) {
            this.registry = (ObservationRegistry)this.beanFactory.getBean(ObservationRegistry.class);
        }
        return this.registry;
    }
}

