/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.dao;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MapTaskExecutionDao
implements TaskExecutionDao {
    private final AtomicLong currentId = new AtomicLong(0L);
    private ConcurrentMap<Long, TaskExecution> taskExecutions = new ConcurrentHashMap<Long, TaskExecution>();
    private ConcurrentMap<Long, Set<Long>> batchJobAssociations = new ConcurrentHashMap<Long, Set<Long>>();

    @Override
    public TaskExecution createTaskExecution(String taskName, LocalDateTime startTime, List<String> arguments, String externalExecutionId) {
        return this.createTaskExecution(taskName, startTime, arguments, externalExecutionId, null);
    }

    @Override
    public TaskExecution createTaskExecution(String taskName, LocalDateTime startTime, List<String> arguments, String externalExecutionId, Long parentExecutionId) {
        long taskExecutionId = this.getNextExecutionId();
        TaskExecution taskExecution = new TaskExecution(taskExecutionId, null, taskName, startTime, null, null, arguments, null, externalExecutionId, parentExecutionId);
        this.taskExecutions.put(taskExecutionId, taskExecution);
        return taskExecution;
    }

    @Override
    public TaskExecution startTaskExecution(long executionId, String taskName, LocalDateTime startTime, List<String> arguments, String externalExecutionid) {
        return this.startTaskExecution(executionId, taskName, startTime, arguments, externalExecutionid, null);
    }

    @Override
    public TaskExecution startTaskExecution(long executionId, String taskName, LocalDateTime startTime, List<String> arguments, String externalExecutionid, Long parentExecutionId) {
        TaskExecution taskExecution = (TaskExecution)this.taskExecutions.get(executionId);
        taskExecution.setTaskName(taskName);
        taskExecution.setStartTime(startTime);
        taskExecution.setArguments(arguments);
        taskExecution.setParentExecutionId(parentExecutionId);
        if (externalExecutionid != null) {
            taskExecution.setExternalExecutionId(externalExecutionid);
        }
        return taskExecution;
    }

    @Override
    public void completeTaskExecution(long executionId, Integer exitCode, LocalDateTime endTime, String exitMessage, String errorMessage) {
        if (!this.taskExecutions.containsKey(executionId)) {
            throw new IllegalStateException("Invalid TaskExecution, ID " + executionId + " not found.");
        }
        TaskExecution taskExecution = (TaskExecution)this.taskExecutions.get(executionId);
        taskExecution.setEndTime(endTime);
        taskExecution.setExitCode(exitCode);
        taskExecution.setExitMessage(exitMessage);
        taskExecution.setErrorMessage(errorMessage);
    }

    @Override
    public void completeTaskExecution(long executionId, Integer exitCode, LocalDateTime endTime, String exitMessage) {
        this.completeTaskExecution(executionId, exitCode, endTime, exitMessage, null);
    }

    @Override
    public TaskExecution getTaskExecution(long executionId) {
        return (TaskExecution)this.taskExecutions.get(executionId);
    }

    @Override
    public long getTaskExecutionCountByTaskName(String taskName) {
        int count = 0;
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long getTaskExecutionCountByExternalExecutionId(String externalExecutionId) {
        int count = 0;
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getExternalExecutionId().equals(externalExecutionId)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long getRunningTaskExecutionCountByTaskName(String taskName) {
        int count = 0;
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName) || ((TaskExecution)entry.getValue()).getEndTime() != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long getRunningTaskExecutionCount() {
        long count = 0L;
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (((TaskExecution)entry.getValue()).getEndTime() != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public long getTaskExecutionCount() {
        return this.taskExecutions.size();
    }

    @Override
    public Page<TaskExecution> findRunningTaskExecutions(String taskName, Pageable pageable) {
        TreeSet<TaskExecution> result = this.getTaskExecutionTreeSet();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName) || ((TaskExecution)entry.getValue()).getEndTime() != null) continue;
            result.add((TaskExecution)entry.getValue());
        }
        return this.getPageFromList(new ArrayList<TaskExecution>(result), pageable, this.getRunningTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public Page<TaskExecution> findTaskExecutionsByExternalExecutionId(String externalExecutionId, Pageable pageable) {
        TreeSet<TaskExecution> result = this.getTaskExecutionTreeSet();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getExternalExecutionId().equals(externalExecutionId)) continue;
            result.add((TaskExecution)entry.getValue());
        }
        return this.getPageFromList(new ArrayList<TaskExecution>(result), pageable, this.getTaskExecutionCountByExternalExecutionId(externalExecutionId));
    }

    @Override
    public Page<TaskExecution> findTaskExecutionsByName(String taskName, Pageable pageable) {
        TreeSet<TaskExecution> filteredSet = this.getTaskExecutionTreeSet();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            if (!((TaskExecution)entry.getValue()).getTaskName().equals(taskName)) continue;
            filteredSet.add((TaskExecution)entry.getValue());
        }
        return this.getPageFromList(new ArrayList<TaskExecution>(filteredSet), pageable, this.getTaskExecutionCountByTaskName(taskName));
    }

    @Override
    public List<String> getTaskNames() {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry entry : this.taskExecutions.entrySet()) {
            result.add(((TaskExecution)entry.getValue()).getTaskName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public Page<TaskExecution> findAll(Pageable pageable) {
        TreeSet<TaskExecution> sortedSet = this.getTaskExecutionTreeSet();
        sortedSet.addAll(this.taskExecutions.values());
        ArrayList<TaskExecution> result = new ArrayList<TaskExecution>(sortedSet.descendingSet());
        return this.getPageFromList(result, pageable, this.getTaskExecutionCount());
    }

    public Map<Long, TaskExecution> getTaskExecutions() {
        return Collections.unmodifiableMap(this.taskExecutions);
    }

    @Override
    public long getNextExecutionId() {
        return this.currentId.getAndIncrement();
    }

    @Override
    public Long getTaskExecutionIdByJobExecutionId(long jobExecutionId) {
        Long taskId = null;
        block0: for (Map.Entry association : this.batchJobAssociations.entrySet()) {
            for (Long curJobExecutionId : (Set)association.getValue()) {
                if (!curJobExecutionId.equals(jobExecutionId)) continue;
                taskId = (Long)association.getKey();
                break block0;
            }
        }
        return taskId;
    }

    @Override
    public Set<Long> getJobExecutionIdsByTaskExecutionId(long taskExecutionId) {
        if (this.batchJobAssociations.containsKey(taskExecutionId)) {
            return Collections.unmodifiableSet((Set)this.batchJobAssociations.get(taskExecutionId));
        }
        return new TreeSet<Long>();
    }

    @Override
    public void updateExternalExecutionId(long taskExecutionId, String externalExecutionId) {
        TaskExecution taskExecution = (TaskExecution)this.taskExecutions.get(taskExecutionId);
        Assert.notNull((Object)taskExecution, (String)("Invalid TaskExecution, ID " + taskExecutionId + " not found."));
        taskExecution.setExternalExecutionId(externalExecutionId);
    }

    public ConcurrentMap<Long, Set<Long>> getBatchJobAssociations() {
        return this.batchJobAssociations;
    }

    private TreeSet<TaskExecution> getTaskExecutionTreeSet() {
        return new TreeSet<TaskExecution>(new Comparator<TaskExecution>(){

            @Override
            public int compare(TaskExecution e1, TaskExecution e2) {
                int result = e1.getStartTime().compareTo(e2.getStartTime());
                if (result == 0) {
                    result = Long.valueOf(e1.getExecutionId()).compareTo(e2.getExecutionId());
                }
                return result;
            }
        });
    }

    private Page getPageFromList(List<TaskExecution> executionList, Pageable pageable, long maxSize) {
        long toIndex = pageable.getOffset() + (long)pageable.getPageSize() > (long)executionList.size() ? (long)executionList.size() : pageable.getOffset() + (long)pageable.getPageSize();
        return new PageImpl(executionList.subList((int)pageable.getOffset(), (int)toIndex), pageable, maxSize);
    }

    @Override
    public List<TaskExecution> getLatestTaskExecutionsByTaskNames(String ... taskNames) {
        Assert.notEmpty((Object[])taskNames, (String)"At least 1 task name must be provided.");
        ArrayList<String> taskNamesAsList = new ArrayList<String>();
        for (String taskName : taskNames) {
            if (!StringUtils.hasText((String)taskName)) continue;
            taskNamesAsList.add(taskName);
        }
        Assert.isTrue((taskNamesAsList.size() == taskNames.length ? 1 : 0) != 0, (String)String.format("Task names must not contain any empty elements but %s of %s were empty or null.", taskNames.length - taskNamesAsList.size(), taskNames.length));
        HashMap<String, TaskExecution> tempTaskExecutions = new HashMap<String, TaskExecution>();
        for (Map.Entry taskExecutionMapEntry : this.taskExecutions.entrySet()) {
            TaskExecution tempTaskExecution;
            if (!taskNamesAsList.contains(((TaskExecution)taskExecutionMapEntry.getValue()).getTaskName()) || (tempTaskExecution = (TaskExecution)tempTaskExecutions.get(((TaskExecution)taskExecutionMapEntry.getValue()).getTaskName())) != null && !tempTaskExecution.getStartTime().isBefore(((TaskExecution)taskExecutionMapEntry.getValue()).getStartTime()) && (!tempTaskExecution.getStartTime().equals(((TaskExecution)taskExecutionMapEntry.getValue()).getStartTime()) || tempTaskExecution.getExecutionId() >= ((TaskExecution)taskExecutionMapEntry.getValue()).getExecutionId())) continue;
            tempTaskExecutions.put(((TaskExecution)taskExecutionMapEntry.getValue()).getTaskName(), (TaskExecution)taskExecutionMapEntry.getValue());
        }
        ArrayList<TaskExecution> latestTaskExecutions = new ArrayList<TaskExecution>(tempTaskExecutions.values());
        Collections.sort(latestTaskExecutions, new TaskExecutionComparator());
        return latestTaskExecutions;
    }

    @Override
    public TaskExecution getLatestTaskExecutionForTaskName(String taskName) {
        Assert.hasText((String)taskName, (String)"The task name must not be empty.");
        List<TaskExecution> taskExecutions = this.getLatestTaskExecutionsByTaskNames(taskName);
        if (taskExecutions.isEmpty()) {
            return null;
        }
        if (taskExecutions.size() == 1) {
            return taskExecutions.get(0);
        }
        throw new IllegalStateException("Only expected a single TaskExecution but received " + taskExecutions.size());
    }

    private static class TaskExecutionComparator
    implements Comparator<TaskExecution>,
    Serializable {
        private TaskExecutionComparator() {
        }

        @Override
        public int compare(TaskExecution firstTaskExecution, TaskExecution secondTaskExecution) {
            if (firstTaskExecution.getStartTime().equals(secondTaskExecution.getStartTime())) {
                return Long.compare(firstTaskExecution.getExecutionId(), secondTaskExecution.getExecutionId());
            }
            return secondTaskExecution.getStartTime().compareTo(firstTaskExecution.getStartTime());
        }
    }
}

