/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.database.support;

import java.util.Map;
import org.springframework.batch.item.database.Order;
import org.springframework.cloud.task.repository.database.support.AbstractSqlPagingQueryProvider;

public final class SqlPagingQueryUtils {
    private SqlPagingQueryUtils() {
    }

    public static String generateLimitJumpToQuery(AbstractSqlPagingQueryProvider provider, String limitClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append((String)(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause()));
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        sql.append(" ").append(limitClause);
        return sql.toString();
    }

    public static String generateTopJumpToQuery(AbstractSqlPagingQueryProvider provider, String topClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(topClause).append(" ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append((String)(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause()));
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        return sql.toString();
    }

    public static void buildWhereClause(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, StringBuilder sql) {
        if (remainingPageQuery) {
            sql.append(" WHERE ");
            if (provider.getWhereClause() != null) {
                sql.append("(");
                sql.append(provider.getWhereClause());
                sql.append(") AND ");
            }
        } else {
            sql.append((String)(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause()));
        }
    }

    public static String buildSortClause(AbstractSqlPagingQueryProvider provider) {
        return SqlPagingQueryUtils.buildSortClause(provider.getSortKeys());
    }

    public static String buildSortClause(Map<String, Order> sortKeys) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Map.Entry<String, Order> sortKey : sortKeys.entrySet()) {
            builder.append(prefix);
            prefix = ", ";
            builder.append(sortKey.getKey());
            if (sortKey.getValue() != null && sortKey.getValue() == Order.DESCENDING) {
                builder.append(" DESC");
                continue;
            }
            builder.append(" ASC");
        }
        return builder.toString();
    }
}

