/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.support;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.util.Assert;

public class SimpleTaskRepository
implements TaskRepository {
    public static final int MAX_EXIT_MESSAGE_SIZE = 2500;
    public static final int MAX_TASK_NAME_SIZE = 100;
    public static final int MAX_ERROR_MESSAGE_SIZE = 2500;
    private static final Log logger = LogFactory.getLog(SimpleTaskRepository.class);
    private TaskExecutionDao taskExecutionDao;
    private FactoryBean<TaskExecutionDao> taskExecutionDaoFactoryBean;
    private boolean initialized = false;
    private int maxExitMessageSize = 2500;
    private int maxTaskNameSize = 100;
    private int maxErrorMessageSize = 2500;

    public SimpleTaskRepository(FactoryBean<TaskExecutionDao> taskExecutionDaoFactoryBean) {
        Assert.notNull(taskExecutionDaoFactoryBean, (String)"A FactoryBean that provides a TaskExecutionDao is required");
        this.taskExecutionDaoFactoryBean = taskExecutionDaoFactoryBean;
    }

    public SimpleTaskRepository(FactoryBean<TaskExecutionDao> taskExecutionDaoFactoryBean, Integer maxExitMessageSize, Integer maxTaskNameSize, Integer maxErrorMessageSize) {
        Assert.notNull(taskExecutionDaoFactoryBean, (String)"A FactoryBean that provides a TaskExecutionDao is required");
        if (maxTaskNameSize != null) {
            this.maxTaskNameSize = maxTaskNameSize;
        }
        if (maxExitMessageSize != null) {
            this.maxExitMessageSize = maxExitMessageSize;
        }
        if (maxErrorMessageSize != null) {
            this.maxErrorMessageSize = maxErrorMessageSize;
        }
        this.taskExecutionDaoFactoryBean = taskExecutionDaoFactoryBean;
    }

    @Override
    public TaskExecution completeTaskExecution(long executionId, Integer exitCode, LocalDateTime endTime, String exitMessage) {
        return this.completeTaskExecution(executionId, exitCode, endTime, exitMessage, null);
    }

    @Override
    public TaskExecution completeTaskExecution(long executionId, Integer exitCode, LocalDateTime endTime, String exitMessage, String errorMessage) {
        this.initialize();
        this.validateCompletedTaskExitInformation(executionId, exitCode, endTime);
        exitMessage = this.trimMessage(exitMessage, this.maxExitMessageSize);
        errorMessage = this.trimMessage(errorMessage, this.maxErrorMessageSize);
        this.taskExecutionDao.completeTaskExecution(executionId, exitCode, endTime, exitMessage, errorMessage);
        logger.debug((Object)("Updating: TaskExecution with executionId=" + executionId + " with the following {exitCode=" + exitCode + ", endTime=" + endTime + ", exitMessage='" + exitMessage + "', errorMessage='" + errorMessage + "'}"));
        return this.taskExecutionDao.getTaskExecution(executionId);
    }

    @Override
    public TaskExecution createTaskExecution(TaskExecution taskExecution) {
        this.initialize();
        this.validateCreateInformation(taskExecution);
        TaskExecution daoTaskExecution = this.taskExecutionDao.createTaskExecution(taskExecution.getTaskName(), taskExecution.getStartTime(), taskExecution.getArguments(), taskExecution.getExternalExecutionId(), taskExecution.getParentExecutionId());
        logger.debug((Object)("Creating: " + taskExecution.toString()));
        return daoTaskExecution;
    }

    @Override
    public TaskExecution createTaskExecution(String name) {
        this.initialize();
        TaskExecution taskExecution = this.taskExecutionDao.createTaskExecution(name, null, Collections.emptyList(), null);
        logger.debug((Object)("Creating: " + taskExecution.toString()));
        return taskExecution;
    }

    @Override
    public TaskExecution createTaskExecution() {
        return this.createTaskExecution((String)null);
    }

    @Override
    public TaskExecution startTaskExecution(long executionid, String taskName, LocalDateTime startTime, List<String> arguments, String externalExecutionId) {
        return this.startTaskExecution(executionid, taskName, startTime, arguments, externalExecutionId, null);
    }

    @Override
    public void updateExternalExecutionId(long executionid, String externalExecutionId) {
        this.initialize();
        this.taskExecutionDao.updateExternalExecutionId(executionid, externalExecutionId);
    }

    @Override
    public TaskExecution startTaskExecution(long executionid, String taskName, LocalDateTime startTime, List<String> arguments, String externalExecutionId, Long parentExecutionId) {
        this.initialize();
        TaskExecution taskExecution = this.taskExecutionDao.startTaskExecution(executionid, taskName, startTime, arguments, externalExecutionId, parentExecutionId);
        logger.debug((Object)("Starting: " + taskExecution.toString()));
        return taskExecution;
    }

    public TaskExecutionDao getTaskExecutionDao() {
        this.initialize();
        return this.taskExecutionDao;
    }

    private void initialize() {
        if (!this.initialized) {
            try {
                this.taskExecutionDao = (TaskExecutionDao)this.taskExecutionDaoFactoryBean.getObject();
                this.initialized = true;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create the TaskExecutionDao", e);
            }
        }
    }

    private void validateCreateInformation(TaskExecution taskExecution) {
        Assert.notNull((Object)taskExecution.getStartTime(), (String)"TaskExecution start time cannot be null.");
        if (taskExecution.getTaskName() != null && taskExecution.getTaskName().length() > this.maxTaskNameSize) {
            throw new IllegalArgumentException("TaskName length exceeds " + this.maxTaskNameSize + " characters");
        }
    }

    private void validateCompletedTaskExitInformation(long executionId, Integer exitCode, LocalDateTime endTime) {
        Assert.notNull((Object)exitCode, (String)"exitCode should not be null");
        Assert.isTrue((exitCode >= 0 ? 1 : 0) != 0, (String)"exit code must be greater than or equal to zero");
        Assert.notNull((Object)endTime, (String)"TaskExecution endTime cannot be null.");
    }

    private String trimMessage(String exitMessage, int maxSize) {
        String result = exitMessage;
        if (exitMessage != null && exitMessage.length() > maxSize) {
            result = exitMessage.substring(0, maxSize);
        }
        return result;
    }

    public void setMaxExitMessageSize(int maxExitMessageSize) {
        this.maxExitMessageSize = maxExitMessageSize;
    }

    public void setMaxTaskNameSize(int maxTaskNameSize) {
        this.maxTaskNameSize = maxTaskNameSize;
    }

    public void setMaxErrorMessageSize(int maxErrorMessageSize) {
        this.maxErrorMessageSize = maxErrorMessageSize;
    }
}

