/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.SkipListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingSkipListener
implements SkipListener {
    private static final Log logger = LogFactory.getLog(EventEmittingSkipListener.class);
    private MessagePublisher<Object> messagePublisher;

    public EventEmittingSkipListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public void onSkipInRead(Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInRead: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader("Skipped when reading.", t.getMessage());
    }

    public void onSkipInWrite(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInWrite: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(item, t.getMessage());
    }

    public void onSkipInProcess(Object item, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onSkipInProcess: " + t.getMessage()), t);
        }
        this.messagePublisher.publishWithThrowableHeader(item, t.getMessage());
    }
}

